/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.impl;

import com.google.common.base.Strings;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.RestException;
import org.symphonyoss.client.exceptions.UserNotFoundException;
import org.symphonyoss.client.exceptions.UsersClientException;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.clients.UsersClient;
import org.symphonyoss.symphony.clients.model.SymUser;
import org.symphonyoss.symphony.pod.api.RoomMembershipApi;
import org.symphonyoss.symphony.pod.api.SessionApi;
import org.symphonyoss.symphony.pod.api.UserApi;
import org.symphonyoss.symphony.pod.api.UsersApi;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.model.AvatarUpdate;
import org.symphonyoss.symphony.pod.model.FeatureList;
import org.symphonyoss.symphony.pod.model.MemberInfo;
import org.symphonyoss.symphony.pod.model.MembershipList;
import org.symphonyoss.symphony.pod.model.SuccessResponse;
import org.symphonyoss.symphony.pod.model.UserAttributes;
import org.symphonyoss.symphony.pod.model.UserCreate;
import org.symphonyoss.symphony.pod.model.UserDetail;
import org.symphonyoss.symphony.pod.model.UserIdList;
import org.symphonyoss.symphony.pod.model.UserStatus;
import org.symphonyoss.symphony.pod.model.UserV2;

public class UsersClientImpl
implements UsersClient {
    private final SymAuth symAuth;
    private final ApiClient apiClient;
    private final Logger logger = LoggerFactory.getLogger(UsersClientImpl.class);

    public UsersClientImpl(SymAuth symAuth, SymphonyClientConfig config) {
        this(symAuth, config, null);
    }

    public UsersClientImpl(SymAuth symAuth, SymphonyClientConfig config, Client httpClient) {
        this.symAuth = symAuth;
        this.apiClient = Configuration.getDefaultApiClient();
        if (httpClient != null) {
            this.apiClient.setHttpClient(httpClient);
        }
        this.apiClient.setBasePath(config.get(SymphonyClientConfigID.POD_URL));
    }

    @Override
    public SymUser getUserFromEmail(String email) throws UsersClientException {
        UserV2 user;
        UsersApi usersApi = new UsersApi(this.apiClient);
        if (email == null) {
            throw new NullPointerException("Email was null");
        }
        try {
            user = usersApi.v2UserGet(this.symAuth.getSessionToken().getToken(), null, email, null, Boolean.valueOf(true));
            if (user == null) {
                user = usersApi.v2UserGet(this.symAuth.getSessionToken().getToken(), null, email, null, Boolean.valueOf(false));
            }
        }
        catch (ApiException e) {
            throw new UsersClientException("API Error communicating with POD, while retrieving user details for " + email, new RestException(usersApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
        if (user != null) {
            this.logger.debug("Found User: {}:{}:{}", new Object[]{user.getEmailAddress(), user.getUsername(), user.getId()});
            return SymUser.toSymUser(user);
        }
        this.logger.warn("Could not locate user: {}", (Object)email);
        throw new UserNotFoundException("Could not find user from email: " + email);
    }

    @Override
    public SymUser getUserFromId(Long userId) throws UsersClientException {
        UserV2 user;
        UsersApi usersApi = new UsersApi(this.apiClient);
        if (userId == null) {
            throw new NullPointerException("UserId was null...");
        }
        try {
            user = usersApi.v2UserGet(this.symAuth.getSessionToken().getToken(), userId, null, null, Boolean.valueOf(true));
            if (user == null) {
                user = usersApi.v2UserGet(this.symAuth.getSessionToken().getToken(), userId, null, null, Boolean.valueOf(false));
            }
        }
        catch (ApiException e) {
            throw new UsersClientException("API Error communicating with POD, while retrieving user details for " + userId, new RestException(usersApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
        if (user != null) {
            this.logger.debug("Found User: {}:{}:{}", new Object[]{user.getDisplayName(), user.getUsername(), user.getId()});
            return SymUser.toSymUser(user);
        }
        throw new UserNotFoundException("Could not find user from ID: " + userId);
    }

    @Override
    public SymUser getUserFromName(String userName) throws UsersClientException {
        UserV2 user;
        UsersApi usersApi = new UsersApi(this.apiClient);
        if (userName == null) {
            throw new NullPointerException("User name was null...");
        }
        try {
            user = usersApi.v2UserGet(this.symAuth.getSessionToken().getToken(), null, null, userName, Boolean.valueOf(true));
        }
        catch (ApiException e) {
            throw new UsersClientException("API Error communicating with POD, while retrieving user details for " + userName, new RestException(usersApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
        if (user != null) {
            this.logger.debug("Found User: {}:{}", (Object)user.getEmailAddress(), (Object)user.getId());
            return SymUser.toSymUser(user);
        }
        throw new UserNotFoundException("Could not find user from user name: " + userName);
    }

    @Override
    public Set<SymUser> getUsersFromStream(String streamId) throws UsersClientException {
        if (streamId == null) {
            throw new NullPointerException("Stream ID was not provided...");
        }
        RoomMembershipApi roomMembershipApi = new RoomMembershipApi(this.apiClient);
        try {
            MembershipList memberInfos = roomMembershipApi.v1RoomIdMembershipListGet(streamId, this.symAuth.getSessionToken().getToken());
            HashSet<SymUser> users = new HashSet<SymUser>();
            for (MemberInfo memberInfo : memberInfos) {
                users.add(this.getUserFromId(memberInfo.getId()));
            }
            return users;
        }
        catch (ApiException e) {
            throw new UsersClientException("Failed to retrieve room membership for room ID: " + streamId, new RestException(roomMembershipApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
    }

    @Override
    public Set<SymUser> getAllUsers() throws UsersClientException {
        UserApi userApi = new UserApi(this.apiClient);
        ConcurrentHashMap.KeySetView symUsers = ConcurrentHashMap.newKeySet();
        try {
            UserIdList userIdList = userApi.v1AdminUserListGet(this.symAuth.getSessionToken().getToken());
            int nThreads = Integer.parseInt(System.getProperty("usersclient.getallusers.threadpool", "8"));
            ExecutorService executor = Executors.newFixedThreadPool(nThreads);
            long startTime = System.currentTimeMillis();
            this.logger.debug("Started to retrieve all users..");
            for (Long userId : userIdList) {
                executor.execute(new Thread(() -> {
                    UserV2 user1;
                    UsersApi usersApi2 = new UsersApi(this.apiClient);
                    if (userId == null) {
                        throw new NullPointerException("UserId was null...");
                    }
                    try {
                        user1 = usersApi2.v2UserGet(this.symAuth.getSessionToken().getToken(), userId, null, null, Boolean.valueOf(true));
                        if (user1 == null) {
                            user1 = usersApi2.v2UserGet(this.symAuth.getSessionToken().getToken(), userId, null, null, Boolean.valueOf(false));
                        }
                    }
                    catch (ApiException e) {
                        this.logger.error("API Error while communicating with POD while retrieving user details", (Throwable)e);
                        return;
                    }
                    if (user1 != null) {
                        SymUser symUser = SymUser.toSymUser(user1);
                        symUsers.add(symUser);
                    }
                }));
            }
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
            this.logger.debug("Finished all threads. Total time retrieving users: {} sec", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        }
        catch (ApiException e) {
            throw new UsersClientException("API Error communicating with POD, while retrieving all user details", new RestException(userApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
        catch (InterruptedException e) {
            this.logger.error("Executor failed to terminate after retrieving all users.", (Throwable)e);
            throw new UsersClientException("Interrupt waiting for search executor to finish", e);
        }
        return symUsers;
    }

    @Override
    public Set<SymUser> getAllUsersWithDetails() throws UsersClientException {
        Set<SymUser> symUsers = this.getAllUsers();
        String sessionToken = this.symAuth.getSessionToken().getToken();
        UserApi userApi = new UserApi(this.apiClient);
        try {
            for (SymUser symUser : symUsers) {
                this.logger.debug("Obtaining user details for {}", (Object)symUser.getDisplayName());
                Long uid = symUser.getId();
                FeatureList featureList = userApi.v1AdminUserUidFeaturesGet(sessionToken, uid);
                symUser.setFeatures(featureList);
                UserDetail userDetail = userApi.v1AdminUserUidGet(sessionToken, uid);
                symUser.setRoles(new HashSet<String>((Collection<String>)userDetail.getRoles()));
                if (userDetail.getUserSystemInfo().getLastLoginDate() != null) {
                    symUser.setLastLoginDate(new Date(userDetail.getUserSystemInfo().getLastLoginDate()));
                }
                if (userDetail.getUserSystemInfo().getCreatedDate() == null) continue;
                symUser.setCreatedDate(new Date(userDetail.getUserSystemInfo().getCreatedDate()));
            }
        }
        catch (ApiException e) {
            throw new UsersClientException("API Error communicating with POD, while retrieving all user details", new RestException(userApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
        return symUsers;
    }

    @Override
    public void setUserStatus(long userId, UserStatus userStatus) throws UsersClientException {
        if (userStatus == null) {
            throw new IllegalArgumentException("Argument userStatus must not be null");
        }
        UserApi usersApi = new UserApi(this.apiClient);
        try {
            String sessionToken = this.getSessionToken();
            SuccessResponse successResponse = usersApi.v1AdminUserUidStatusUpdatePost(sessionToken, Long.valueOf(userId), userStatus);
            if (successResponse == null) {
                throw new IllegalStateException("Update user status response must not be null");
            }
        }
        catch (ApiException e) {
            String message = "API error communicating with POD, while settIng status " + userStatus.getStatus() + " for user id: " + userId;
            this.logger.error(message, (Throwable)e);
            throw new UsersClientException(message, new RestException(usersApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
        catch (IllegalStateException e) {
            String message = "Failed to set status " + userStatus.getStatus() + " for user id: " + userId;
            this.logger.error(message, (Throwable)e);
            throw new UsersClientException(message, e);
        }
    }

    @Override
    public SymUser updateUser(long userId, SymUser symUser) throws UsersClientException {
        SymUser updatedSymUser;
        UserApi usersApi = new UserApi(this.apiClient);
        try {
            String sessionToken = this.getSessionToken();
            UserAttributes userAttributes = SymUser.toUserAttributes(symUser);
            UserDetail userDetail = usersApi.v1AdminUserUidUpdatePost(sessionToken, Long.valueOf(userId), userAttributes);
            if (userDetail == null) {
                throw new IllegalStateException("Update user response must not be null");
            }
            updatedSymUser = SymUser.toSymUser(userDetail);
        }
        catch (ApiException e) {
            String message = "API error communicating with POD, while updating user";
            this.logger.error(message, (Throwable)e);
            throw new UsersClientException(message, new RestException(usersApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
        catch (IllegalStateException e) {
            String message = "Failed to update user";
            this.logger.error(message, (Throwable)e);
            throw new UsersClientException(message, e);
        }
        return updatedSymUser;
    }

    @Override
    public SymUser createUser(UserCreate userCreate) throws UsersClientException {
        UserDetail userDetail;
        UserApi usersApi = new UserApi(this.apiClient);
        try {
            String sessionToken = this.getSessionToken();
            userDetail = usersApi.v1AdminUserCreatePost(sessionToken, userCreate);
            if (userDetail == null) {
                throw new IllegalStateException("User Detail must not be null");
            }
        }
        catch (ApiException e) {
            String message = "API error communicating with POD, while creating user";
            this.logger.error(message, (Throwable)e);
            throw new UsersClientException(message, new RestException(usersApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
        catch (IllegalStateException e) {
            String message = "Failed to create user";
            this.logger.error(message, (Throwable)e);
            throw new UsersClientException(message, e);
        }
        return SymUser.toSymUser(userDetail);
    }

    private String getSessionToken() throws IllegalStateException {
        String sessionToken = this.symAuth.getSessionToken().getToken();
        if (Strings.isNullOrEmpty((String)sessionToken)) {
            throw new IllegalStateException("Invalid session token string: it must not be null or empty");
        }
        return sessionToken;
    }

    @Override
    public SymUser getUserBySession(SymAuth symAuth) throws UsersClientException {
        if (symAuth == null) {
            return null;
        }
        SessionApi sessionApi = new SessionApi(this.apiClient);
        try {
            return SymUser.toSymUser(sessionApi.v2SessioninfoGet(symAuth.getSessionToken().getToken()));
        }
        catch (ApiException e) {
            throw new UsersClientException("Unable to obtain user by session token", e);
        }
    }

    @Override
    public void updateUserAvatar(long userId, byte[] avatar) throws UsersClientException {
        if (avatar != null) {
            UserApi usersApi = new UserApi(this.apiClient);
            try {
                String sessionToken = this.getSessionToken();
                String image = Base64.getEncoder().encodeToString(avatar);
                AvatarUpdate avatarUpdate = new AvatarUpdate();
                avatarUpdate.setImage(image);
                SuccessResponse response = usersApi.v1AdminUserUidAvatarUpdatePost(sessionToken, Long.valueOf(userId), avatarUpdate);
                if (!"OK".equals(response.getMessage())) {
                    throw new IllegalStateException("The message differs from expected OK message. Response message: " + response.getMessage());
                }
            }
            catch (ApiException e) {
                String message = "API error communicating with POD, while updating avatar";
                this.logger.error(message, (Throwable)e);
                throw new UsersClientException(message, new RestException(usersApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
            }
            catch (IllegalStateException e) {
                String message = "Avatar update failed";
                this.logger.error(message, (Throwable)e);
                throw new UsersClientException(message);
            }
        }
    }
}

