/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.symphonyoss.client.common.MLTypes;
import org.symphonyoss.client.exceptions.SymException;
import org.symphonyoss.client.util.MlMessageParser;
import org.symphonyoss.symphony.agent.model.V2BaseMessage;
import org.symphonyoss.symphony.agent.model.V2Message;
import org.symphonyoss.symphony.agent.model.V4Message;
import org.symphonyoss.symphony.clients.model.ApiVersion;
import org.symphonyoss.symphony.clients.model.SymAttachmentInfo;
import org.symphonyoss.symphony.clients.model.SymStream;
import org.symphonyoss.symphony.clients.model.SymUser;

public class SymMessage {
    private String id = null;
    private String timestamp = null;
    @Deprecated
    private String messageType = null;
    private String streamId = null;
    private String message = null;
    private Long fromUserId = null;
    private SymUser symUser = null;
    private SymStream stream = null;
    private List<SymAttachmentInfo> attachments = new ArrayList<SymAttachmentInfo>();
    private String entityData = null;
    private File attachment = null;
    private File attachementThumbnail = null;
    private ApiVersion apiVersion = null;

    public SymUser getSymUser() {
        return this.symUser;
    }

    public void setSymUser(SymUser symUser) {
        this.symUser = symUser;
        this.fromUserId = symUser.getId();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Long getFromUserId() {
        return this.fromUserId;
    }

    public void setFromUserId(Long fromUserId) {
        this.fromUserId = fromUserId;
        if (this.symUser == null) {
            this.symUser = new SymUser();
        }
        this.symUser.setId(fromUserId);
    }

    public List<SymAttachmentInfo> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<SymAttachmentInfo> attachments) {
        this.attachments = attachments;
    }

    public String getEntityData() {
        return this.entityData;
    }

    public void setEntityData(String entityData) {
        this.entityData = entityData;
    }

    public SymStream getStream() {
        return this.stream;
    }

    public void setStream(SymStream stream) {
        this.stream = stream;
    }

    public File getAttachment() {
        return this.attachment;
    }

    public void setAttachment(File attachment) {
        this.attachment = attachment;
    }

    public File getAttachementThumbnail() {
        return this.attachementThumbnail;
    }

    public void setAttachementThumbnail(File attachementThumbnail) {
        this.attachementThumbnail = attachementThumbnail;
    }

    public ApiVersion getApiVersion() {
        if (this.apiVersion == null) {
            this.apiVersion = ApiVersion.V4;
        }
        return this.apiVersion;
    }

    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    public static SymMessage toSymMessage(V2BaseMessage v2BaseMessage) {
        SymMessage symMessage = new SymMessage();
        symMessage.setTimestamp(v2BaseMessage.getTimestamp());
        symMessage.setId(v2BaseMessage.getId());
        symMessage.setStreamId(v2BaseMessage.getStreamId());
        symMessage.setMessageType(v2BaseMessage.getV2messageType());
        if (v2BaseMessage instanceof V2Message) {
            symMessage.setMessage(((V2Message)v2BaseMessage).getMessage());
            symMessage.setFromUserId(((V2Message)v2BaseMessage).getFromUserId());
            symMessage.setAttachments(SymAttachmentInfo.toAttachmentsInfo(((V2Message)v2BaseMessage).getAttachments()));
        }
        return symMessage;
    }

    public static SymMessage toSymMessage(V4Message v4Message) {
        SymMessage symMessage = new SymMessage();
        symMessage.setTimestamp(Long.toString(v4Message.getTimestamp()));
        symMessage.setId(v4Message.getMessageId());
        symMessage.setStreamId(v4Message.getStream().getStreamId());
        symMessage.setFromUserId(v4Message.getUser().getUserId());
        symMessage.setSymUser(SymUser.toSymUser(v4Message.getUser()));
        symMessage.setMessage(v4Message.getMessage());
        symMessage.setStream(SymStream.toSymStream(v4Message.getStream()));
        if (v4Message.getAttachments() != null) {
            symMessage.setAttachments(SymAttachmentInfo.toAttachmentsInfos(v4Message.getAttachments()));
        }
        symMessage.setEntityData(v4Message.getData());
        return symMessage;
    }

    public String getMessageText() {
        MlMessageParser mlMessageParser = new MlMessageParser();
        if (this.message != null) {
            try {
                mlMessageParser.parseMessage(this.message);
                return mlMessageParser.getText();
            }
            catch (SymException e) {
                System.out.println("Could not parse message...");
            }
        }
        return null;
    }

    public void setMessageText(ApiVersion apiVersion, String text) {
        text = StringEscapeUtils.escapeXml((String)text);
        if (apiVersion != null && !apiVersion.equals((Object)ApiVersion.V2)) {
            this.setMessage((Object)((Object)MLTypes.START_PML) + text + (Object)((Object)MLTypes.END_PML));
        } else {
            this.setMessageType("MESSAGEML");
            this.setMessage((Object)((Object)MLTypes.START_ML) + text + (Object)((Object)MLTypes.END_ML));
        }
    }

    public void setMessageText(String text) {
        this.setMessageText(this.apiVersion, text);
    }
}

