/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.symphonyoss.symphony.pod.model.Presence;
import org.symphonyoss.symphony.pod.model.V2Presence;
import org.symphonyoss.symphony.pod.model.V2PresenceList;

public class SymPresence {
    private Long userId = null;
    private Long timestamp = null;
    private Category category = null;

    public Category state(Category category) {
        this.category = category;
        return this.category;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymPresence symPresence = (SymPresence)o;
        return Objects.equals((Object)this.category, (Object)symPresence.category);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SymPresence {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public static SymPresence toSymPresence(Presence presence) {
        if (presence == null) {
            return null;
        }
        SymPresence symPresence = new SymPresence();
        symPresence.setCategory(Category.fromValue(presence.getCategory().toString()));
        return symPresence;
    }

    public static SymPresence toSymPresence(V2Presence presence) {
        if (presence == null) {
            return null;
        }
        SymPresence symPresence = new SymPresence();
        symPresence.setCategory(Category.fromValue(presence.getCategory()));
        symPresence.setTimestamp(presence.getTimestamp());
        symPresence.setUserId(presence.getUserId());
        return symPresence;
    }

    public static List<SymPresence> toSymPresence(V2PresenceList presences) {
        if (presences == null) {
            return null;
        }
        ArrayList<SymPresence> symPresences = new ArrayList<SymPresence>();
        presences.forEach(v2Presence -> symPresences.add(SymPresence.toSymPresence(v2Presence)));
        return symPresences;
    }

    public static enum Category {
        UNDEFINED("UNDEFINED"),
        AVAILABLE("AVAILABLE"),
        BUSY("BUSY"),
        DO_NOT_DISTURB("DO_NOT_DISTURB"),
        ON_THE_PHONE("ON_THE_PHONE"),
        BE_RIGHT_BACK("BE_RIGHT_BACK"),
        AWAY("AWAY"),
        OUT_OF_OFFICE("OUT_OF_OFFICE"),
        IN_A_MEETING("IN_A_MEETING"),
        OFF_WORK("OFF_WORK"),
        OFFLINE("OFFLINE");

        private String value;

        private Category(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static Category fromValue(String text) {
            for (Category b : Category.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

