/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.symphonyoss.symphony.agent.model.V4Stream;
import org.symphonyoss.symphony.clients.model.SymStreamTypes;
import org.symphonyoss.symphony.clients.model.SymUser;
import org.symphonyoss.symphony.pod.model.Stream;

public class SymStream {
    private String streamId = null;
    private SymStreamTypes.Type streamType = null;
    private String roomName = null;
    private List<SymUser> members = new ArrayList<SymUser>();
    private Boolean external = null;

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public SymStreamTypes.Type getStreamType() {
        return this.streamType;
    }

    public void setStreamType(SymStreamTypes.Type streamType) {
        this.streamType = streamType;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public List<SymUser> getMembers() {
        return this.members;
    }

    public void setMembers(List<SymUser> members) {
        this.members = members;
    }

    public Boolean getExternal() {
        return this.external;
    }

    public void setExternal(Boolean external) {
        this.external = external;
    }

    public static SymStream toSymStream(V4Stream stream) {
        if (stream == null) {
            return null;
        }
        SymStream symStream = new SymStream();
        symStream.setExternal(stream.getExternal());
        if (stream.getMembers() != null) {
            symStream.setMembers(stream.getMembers().stream().map(SymUser::toSymUser).collect(Collectors.toList()));
        }
        if (stream.getRoomName() != null) {
            symStream.setRoomName(stream.getRoomName());
        }
        symStream.setStreamId(stream.getStreamId());
        symStream.setStreamType(SymStreamTypes.Type.fromValue(stream.getStreamType()));
        return symStream;
    }

    public static Stream toSymStream(SymStream symStream) {
        if (symStream == null) {
            return null;
        }
        Stream stream = new Stream();
        stream.setId(symStream.getStreamId());
        return stream;
    }

    public static SymStream toSymStream(Stream stream) {
        if (stream == null) {
            return null;
        }
        SymStream symStream = new SymStream();
        symStream.setStreamId(stream.getId());
        return symStream;
    }
}

