/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.symphonyoss.symphony.clients.model.SymStreamTypes;
import org.symphonyoss.symphony.pod.model.StreamFilter;
import org.symphonyoss.symphony.pod.model.StreamType;

public class SymStreamFilter {
    private List<SymStreamTypes> streamTypes = new ArrayList<SymStreamTypes>();
    private Boolean includeInactiveStreams = null;

    public List<SymStreamTypes> getStreamTypes() {
        return this.streamTypes;
    }

    public void setStreamTypes(List<SymStreamTypes> streamTypes) {
        this.streamTypes = streamTypes;
    }

    public Boolean getIncludeInactiveStreams() {
        return this.includeInactiveStreams;
    }

    public void setIncludeInactiveStreams(Boolean includeInactiveStreams) {
        this.includeInactiveStreams = includeInactiveStreams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymStreamFilter streamFilter = (SymStreamFilter)o;
        return Objects.equals(this.streamTypes, streamFilter.streamTypes) && Objects.equals(this.includeInactiveStreams, streamFilter.includeInactiveStreams);
    }

    public int hashCode() {
        return Objects.hash(this.streamTypes, this.includeInactiveStreams);
    }

    public static StreamFilter toStreamFilter(SymStreamFilter symStreamFilter) {
        if (symStreamFilter == null) {
            return null;
        }
        StreamFilter streamFilter = new StreamFilter();
        streamFilter.setIncludeInactiveStreams(symStreamFilter.getIncludeInactiveStreams());
        if (symStreamFilter.getStreamTypes() != null) {
            ArrayList<StreamType> streamTypes = new ArrayList<StreamType>();
            for (SymStreamTypes symStreamTypes : symStreamFilter.getStreamTypes()) {
                StreamType streamType = new StreamType();
                streamType.setType(StreamType.TypeEnum.fromValue((String)symStreamTypes.getType().toString()));
                streamTypes.add(streamType);
            }
            streamFilter.setStreamTypes(streamTypes);
        }
        return streamFilter;
    }

    public static SymStreamFilter toSymStreamFilter(StreamFilter streamFilter) {
        if (streamFilter == null) {
            return null;
        }
        SymStreamFilter symStreamFilter = new SymStreamFilter();
        symStreamFilter.setIncludeInactiveStreams(streamFilter.getIncludeInactiveStreams());
        if (streamFilter.getStreamTypes() != null) {
            ArrayList<SymStreamTypes> symStreamTypes = new ArrayList<SymStreamTypes>();
            for (StreamType streamType : streamFilter.getStreamTypes()) {
                SymStreamTypes symStreamType = new SymStreamTypes();
                symStreamType.setType(SymStreamTypes.Type.fromValue(streamType.getType().toString()));
                symStreamTypes.add(symStreamType);
            }
            symStreamFilter.setStreamTypes(symStreamTypes);
        }
        return symStreamFilter;
    }
}

