/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.symphonyoss.symphony.agent.model.V4User;
import org.symphonyoss.symphony.clients.model.SymAvatar;
import org.symphonyoss.symphony.pod.model.Avatar;
import org.symphonyoss.symphony.pod.model.AvatarList;
import org.symphonyoss.symphony.pod.model.FeatureList;
import org.symphonyoss.symphony.pod.model.StringList;
import org.symphonyoss.symphony.pod.model.UserAttributes;
import org.symphonyoss.symphony.pod.model.UserDetail;
import org.symphonyoss.symphony.pod.model.UserSystemInfo;
import org.symphonyoss.symphony.pod.model.UserV2;

public class SymUser {
    private Long id;
    private String emailAddress;
    private String firstName;
    private String lastName;
    private String department;
    private String displayName;
    private String title;
    private String company;
    private String username;
    private String location;
    private List<SymAvatar> avatars;
    private Date lastLoginDate;
    private Date createdDate;
    private boolean active;
    private Set<String> roles;
    private FeatureList features;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public List<SymAvatar> getAvatars() {
        return this.avatars;
    }

    public void setAvatars(List<SymAvatar> avatars) {
        this.avatars = avatars;
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public FeatureList getFeatures() {
        return this.features;
    }

    public void setFeatures(FeatureList features) {
        this.features = features;
    }

    public static UserV2 toUserV2(SymUser symUser) {
        if (symUser == null) {
            return null;
        }
        UserV2 userV2 = new UserV2();
        userV2.setCompany(symUser.getCompany());
        userV2.setDisplayName(symUser.getDisplayName());
        userV2.setEmailAddress(symUser.getEmailAddress());
        userV2.setFirstName(symUser.getFirstName());
        userV2.setLastName(symUser.getLastName());
        userV2.setId(symUser.getId());
        userV2.setLocation(symUser.getLocation());
        userV2.setTitle(symUser.getTitle());
        userV2.setUsername(symUser.getUsername());
        userV2.setDepartment(symUser.getDepartment());
        AvatarList avatars = new AvatarList();
        for (SymAvatar symAvatar : symUser.getAvatars()) {
            Avatar avatar = new Avatar();
            avatar.setSize(symAvatar.getSize());
            avatar.setUrl(symAvatar.getUrl());
            avatars.add((Object)avatar);
        }
        userV2.setAvatars(avatars);
        return userV2;
    }

    public static SymUser toSymUser(UserV2 user) {
        if (user == null) {
            return null;
        }
        SymUser symUser = new SymUser();
        symUser.setCompany(user.getCompany());
        symUser.setDisplayName(user.getDisplayName());
        symUser.setEmailAddress(user.getEmailAddress());
        symUser.setFirstName(user.getFirstName());
        symUser.setLastName(user.getLastName());
        symUser.setId(user.getId());
        symUser.setLocation(user.getLocation());
        symUser.setTitle(user.getTitle());
        symUser.setUsername(user.getUsername());
        symUser.setDepartment(user.getDepartment());
        ArrayList<SymAvatar> avatars = new ArrayList<SymAvatar>();
        for (Avatar avatar : user.getAvatars()) {
            SymAvatar symAvatar = new SymAvatar();
            symAvatar.setSize(avatar.getSize());
            symAvatar.setUrl(avatar.getUrl());
            avatars.add(symAvatar);
        }
        symUser.setAvatars(avatars);
        return symUser;
    }

    public static SymUser toSymUser(V4User user) {
        if (user == null) {
            return null;
        }
        SymUser symUser = new SymUser();
        symUser.setDisplayName(user.getDisplayName());
        symUser.setEmailAddress(user.getEmail());
        symUser.setFirstName(user.getFirstName());
        symUser.setLastName(user.getLastName());
        symUser.setId(user.getUserId());
        symUser.setUsername(user.getUsername());
        symUser.setDepartment(null);
        return symUser;
    }

    public static SymUser toSymUser(UserDetail userDetail) {
        if (userDetail == null) {
            throw new IllegalStateException("User Detail must not be null");
        }
        UserAttributes userAttributes = userDetail.getUserAttributes();
        if (userAttributes == null) {
            throw new IllegalStateException("User Attributes must not be null");
        }
        UserSystemInfo userSystemInfo = userDetail.getUserSystemInfo();
        if (userSystemInfo == null) {
            throw new IllegalStateException("User System Info must not be null");
        }
        SymUser symUser = new SymUser();
        symUser.setDisplayName(userAttributes.getDisplayName());
        symUser.setEmailAddress(userAttributes.getEmailAddress());
        symUser.setFirstName(userAttributes.getFirstName());
        symUser.setLastName(userAttributes.getLastName());
        symUser.setId(userSystemInfo.getId());
        symUser.setLocation(userAttributes.getLocation());
        symUser.setTitle(userAttributes.getTitle());
        symUser.setUsername(userAttributes.getUserName());
        symUser.setDepartment(userAttributes.getDepartment());
        Long lastLoginDate = userSystemInfo.getLastLoginDate();
        if (null != lastLoginDate) {
            symUser.setLastLoginDate(new Date(lastLoginDate));
        } else {
            symUser.setLastLoginDate(null);
        }
        Long createdDate = userSystemInfo.getCreatedDate();
        if (null != createdDate) {
            symUser.setCreatedDate(new Date(createdDate));
        } else {
            symUser.setCreatedDate(null);
        }
        symUser.setActive(UserSystemInfo.StatusEnum.ENABLED == userSystemInfo.getStatus());
        StringList roles = userDetail.getRoles();
        if (null != roles) {
            symUser.setRoles(new HashSet<String>((Collection<String>)roles));
        } else {
            symUser.setRoles(new HashSet<String>());
        }
        return symUser;
    }

    public static UserAttributes toUserAttributes(SymUser symUser) {
        if (symUser == null) {
            throw new IllegalStateException("symUser must not be null");
        }
        UserAttributes userAttributes = new UserAttributes();
        userAttributes.setDisplayName(symUser.getDisplayName());
        userAttributes.setEmailAddress(symUser.getEmailAddress());
        userAttributes.setFirstName(symUser.getFirstName());
        userAttributes.setLastName(symUser.getLastName());
        userAttributes.setLocation(symUser.getLocation());
        userAttributes.setTitle(symUser.getTitle());
        userAttributes.setUserName(symUser.getUsername());
        userAttributes.setDepartment(symUser.getDepartment());
        return userAttributes;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SymUser)) {
            return false;
        }
        SymUser symUser = (SymUser)o;
        return this.id.equals(symUser.id);
    }
}

