/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.pod.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Password. Stored as derived password in both the Pod and the Key Manager using PBKDF2 function. Number of iterations should be 10000 and desired length 256 bits.")
public class Password {
    @JsonProperty(value="hSalt")
    private String hSalt = null;
    @JsonProperty(value="hPassword")
    private String hPassword = null;
    @JsonProperty(value="khSalt")
    private String khSalt = null;
    @JsonProperty(value="khPassword")
    private String khPassword = null;

    public Password hSalt(String hSalt) {
        this.hSalt = hSalt;
        return this;
    }

    @ApiModelProperty(value="Pod password salt used for PBKDF2 derivation.")
    public String getHSalt() {
        return this.hSalt;
    }

    public void setHSalt(String hSalt) {
        this.hSalt = hSalt;
    }

    public Password hPassword(String hPassword) {
        this.hPassword = hPassword;
        return this;
    }

    @ApiModelProperty(value="Pod password derived with PBKDF2.")
    public String getHPassword() {
        return this.hPassword;
    }

    public void setHPassword(String hPassword) {
        this.hPassword = hPassword;
    }

    public Password khSalt(String khSalt) {
        this.khSalt = khSalt;
        return this;
    }

    @ApiModelProperty(value="Key Manager password salt used for PBKDF2 derivation.")
    public String getKhSalt() {
        return this.khSalt;
    }

    public void setKhSalt(String khSalt) {
        this.khSalt = khSalt;
    }

    public Password khPassword(String khPassword) {
        this.khPassword = khPassword;
        return this;
    }

    @ApiModelProperty(value="Key Manager password derived with PBKDF2.")
    public String getKhPassword() {
        return this.khPassword;
    }

    public void setKhPassword(String khPassword) {
        this.khPassword = khPassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Password password = (Password)o;
        return Objects.equals(this.hSalt, password.hSalt) && Objects.equals(this.hPassword, password.hPassword) && Objects.equals(this.khSalt, password.khSalt) && Objects.equals(this.khPassword, password.khPassword);
    }

    public int hashCode() {
        return Objects.hash(this.hSalt, this.hPassword, this.khSalt, this.khPassword);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Password {\n");
        sb.append("    hSalt: ").append(this.toIndentedString(this.hSalt)).append("\n");
        sb.append("    hPassword: ").append(this.toIndentedString(this.hPassword)).append("\n");
        sb.append("    khSalt: ").append(this.toIndentedString(this.khSalt)).append("\n");
        sb.append("    khPassword: ").append(this.toIndentedString(this.khPassword)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

