/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cloud.nio.multipart.MultipartContext;
import org.synchronoss.cloud.nio.multipart.NioMultipartParser;
import org.synchronoss.cloud.nio.multipart.NioMultipartParserListener;
import org.synchronoss.cloud.nio.multipart.PartBodyStreamStorageFactory;
import org.synchronoss.cloud.nio.multipart.util.collect.AbstractIterator;
import org.synchronoss.cloud.nio.multipart.util.collect.CloseableIterator;
import org.synchronoss.cloud.nio.stream.storage.StreamStorage;

public class BlockingIOAdapter {
    private static final Logger log = LoggerFactory.getLogger(BlockingIOAdapter.class);

    public static CloseableIterator<PartItem> parse(InputStream inputStream, MultipartContext multipartContext) {
        return BlockingIOAdapter.parse(inputStream, multipartContext, null, 16384, 16384, 1);
    }

    public static CloseableIterator<PartItem> parse(InputStream inputStream, MultipartContext multipartContext, PartBodyStreamStorageFactory partBodyStreamStorageFactory) {
        return BlockingIOAdapter.parse(inputStream, multipartContext, partBodyStreamStorageFactory, 16384, 16384, 1);
    }

    public static CloseableIterator<PartItem> parse(InputStream inputStream, MultipartContext multipartContext, int bufferSize) {
        return BlockingIOAdapter.parse(inputStream, multipartContext, null, bufferSize, 16384, 1);
    }

    public static CloseableIterator<PartItem> parse(InputStream inputStream, MultipartContext multipartContext, PartBodyStreamStorageFactory partBodyStreamStorageFactory, int bufferSize, int maxHeadersSectionSize, int maxLevelOfNestedMultipart) {
        return new PartItemsIterator(inputStream, multipartContext, partBodyStreamStorageFactory, bufferSize, maxHeadersSectionSize, maxLevelOfNestedMultipart);
    }

    public static class Attachment
    implements PartItem {
        final Map<String, List<String>> headers;
        final StreamStorage partBodyStreamStorage;

        private Attachment(Map<String, List<String>> headers, StreamStorage partBodyStreamStorage) {
            this.headers = headers;
            this.partBodyStreamStorage = partBodyStreamStorage;
        }

        @Override
        public PartItem.Type getType() {
            return PartItem.Type.ATTACHMENT;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public InputStream getPartBody() {
            return this.partBodyStreamStorage.getInputStream();
        }
    }

    public static class FormParameter
    implements PartItem {
        final Map<String, List<String>> headers;
        final String fieldName;
        final String fieldValue;

        private FormParameter(Map<String, List<String>> headers, String fieldName, String fieldValue) {
            this.headers = headers;
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
        }

        @Override
        public PartItem.Type getType() {
            return PartItem.Type.FORM;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }
    }

    public static class NestedStart
    implements PartItem {
        final Map<String, List<String>> headers;

        private NestedStart(Map<String, List<String>> headers) {
            this.headers = headers;
        }

        @Override
        public PartItem.Type getType() {
            return PartItem.Type.NESTED_START;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }
    }

    public static class NestedEnd
    implements PartItem {
        private NestedEnd() {
        }

        @Override
        public PartItem.Type getType() {
            return PartItem.Type.NESTED_END;
        }
    }

    public static interface PartItem {
        public Type getType();

        public static enum Type {
            FORM,
            ATTACHMENT,
            NESTED_START,
            NESTED_END;

        }
    }

    static class PartItemsIterator
    extends AbstractIterator<PartItem>
    implements CloseableIterator<PartItem> {
        private static final PartItem END_OF_DATA = new PartItem(){

            @Override
            public PartItem.Type getType() {
                return null;
            }
        };
        private Queue<PartItem> partItems = new ConcurrentLinkedQueue<PartItem>();
        private final NioMultipartParser parser;
        private final InputStream inputStream;

        public PartItemsIterator(InputStream inputStream, MultipartContext multipartContext, PartBodyStreamStorageFactory partBodyStreamStorageFactory, int bufferSize, int maxHeadersSectionSize, int maxLevelOfNestedMultipart) {
            this.inputStream = inputStream;
            NioMultipartParserListener listener = new NioMultipartParserListener(){

                @Override
                public void onPartFinished(StreamStorage partBodyStreamStorage, Map<String, List<String>> headersFromPart) {
                    PartItemsIterator.this.partItems.add(new Attachment(headersFromPart, partBodyStreamStorage));
                }

                @Override
                public void onFormFieldPartFinished(String fieldName, String fieldValue, Map<String, List<String>> headersFromPart) {
                    PartItemsIterator.this.partItems.add(new FormParameter(headersFromPart, fieldName, fieldValue));
                }

                @Override
                public void onAllPartsFinished() {
                    PartItemsIterator.this.partItems.add(END_OF_DATA);
                }

                @Override
                public void onNestedPartStarted(Map<String, List<String>> headersFromParentPart) {
                    PartItemsIterator.this.partItems.add(new NestedStart(headersFromParentPart));
                }

                @Override
                public void onNestedPartFinished() {
                    PartItemsIterator.this.partItems.add(new NestedEnd());
                }

                @Override
                public void onError(String message, Throwable cause) {
                    throw new IllegalStateException("Error parsing the multipart stream: " + message, cause);
                }
            };
            this.parser = new NioMultipartParser(multipartContext, listener, partBodyStreamStorageFactory, bufferSize, maxHeadersSectionSize, maxLevelOfNestedMultipart);
        }

        @Override
        protected PartItem computeNext() {
            byte[] buffer = new byte[1024];
            try {
                int read;
                PartItem next = this.partItems.poll();
                if (next != null && next.getType() == null) {
                    return (PartItem)this.endOfData();
                }
                if (next != null) {
                    return next;
                }
                while (null == (next = this.partItems.poll()) && -1 != (read = this.inputStream.read(buffer))) {
                    this.parser.write(buffer, 0, read);
                }
                if (next != null && next.getType() == null) {
                    return (PartItem)this.endOfData();
                }
                if (next != null) {
                    return next;
                }
                throw new IllegalStateException("Error parsing the multipart stream. Stream ended unexpectedly");
            }
            catch (Exception e) {
                throw new IllegalStateException("Error parsing the multipart stream", e);
            }
        }

        @Override
        public void close() throws IOException {
            this.parser.close();
        }
    }
}

