/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpConfig;

public class Cookie {
    private static Logger log = LoggerFactory.getLogger(Cookie.class);
    private String domain = null;
    private String path = null;
    private Long maxAge = null;
    private String expires = null;
    private boolean secure = false;
    private boolean httpOnly = false;
    private String name;
    private String value;
    private byte[] bytes;

    public static Cookie buildCookie(Map<String, String> cookieMap, HttpConfig httpConfig) {
        Cookie cookie = new Cookie();
        block18: for (Map.Entry<String, String> cookieMapItem : cookieMap.entrySet()) {
            switch (cookieMapItem.getKey().toLowerCase()) {
                case "domain": {
                    cookie.setDomain(cookieMapItem.getValue());
                    continue block18;
                }
                case "path": {
                    cookie.setPath(cookieMapItem.getValue());
                    continue block18;
                }
                case "max-age": {
                    cookie.setMaxAge(Long.parseLong(cookieMapItem.getValue()));
                    continue block18;
                }
                case "secure": {
                    cookie.setSecure(true);
                    continue block18;
                }
                case "httponly": {
                    cookie.setHttpOnly(true);
                    continue block18;
                }
                case "expires": {
                    cookie.setExpires(cookieMapItem.getValue());
                    continue block18;
                }
            }
            cookie.setName(cookieMapItem.getKey());
            try {
                cookie.setValue(URLDecoder.decode(cookieMapItem.getValue(), httpConfig.getCharset()));
            }
            catch (Exception e) {
                log.error("cookie\u503c\u89e3\u7801\u65f6\u5f02\u5e38\uff1a" + cookieMapItem.getValue(), (Throwable)e);
            }
        }
        return cookie;
    }

    public static Map<String, String> getEqualMap(String cookieline) {
        String[] searchedStrings;
        HashMap<String, String> equalMap = new HashMap<String, String>();
        for (String groupString : searchedStrings = Cookie.searchByRegex(cookieline, "([^ ;,]+=[^ ;,]+)")) {
            String[] equalStrings = new String[2];
            int equalCharIndex = groupString.indexOf("=");
            equalStrings[0] = groupString.substring(0, equalCharIndex);
            equalStrings[1] = groupString.substring(equalCharIndex + 1, groupString.length());
            if (equalStrings.length != 2) continue;
            String key = equalStrings[0];
            String value = equalStrings[1];
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            equalMap.put(key, value);
        }
        return equalMap;
    }

    public static String[] searchByRegex(String source, String regex) {
        if (source == null) {
            return null;
        }
        HashMap<Integer, Pattern> regexPattern = new HashMap<Integer, Pattern>();
        Pattern pattern = null;
        if (regexPattern.containsKey(regex.hashCode())) {
            pattern = (Pattern)regexPattern.get(regex.hashCode());
        } else {
            pattern = Pattern.compile(regex);
            regexPattern.put(regex.hashCode(), pattern);
        }
        Matcher matcher = pattern.matcher(source);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result.toArray(new String[0]);
    }

    public Cookie(String domain, String name, String value, Long maxAge) {
        this.setName(name);
        this.setValue(value);
        this.setPath("/");
        this.setDomain(domain);
        this.setMaxAge(maxAge);
        this.setHttpOnly(false);
    }

    private Cookie() {
    }

    public String getDomain() {
        return this.domain;
    }

    public String getExpires() {
        return this.expires;
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setExpires(String expires) {
        this.expires = expires;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public void setMaxAge(Long maxAge) {
        this.maxAge = maxAge;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return (this.name != null || this.value != null ? this.name + "=" + this.value : "") + (this.domain != null ? "; Domain=" + this.domain : "") + (this.maxAge != null ? "; Max-Age=" + this.maxAge : "") + (this.path != null ? "; Path=" + this.path : " ") + (this.httpOnly ? "; httponly; " : "") + (this.secure ? "; Secure" : "");
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }
}

