/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ThreadPoolExecutor;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.intf.TioUuid;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpUuid;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.common.session.id.ISessionIdGenerator;
import org.tio.http.common.session.id.impl.UUIDSessionIdGenerator;
import org.tio.http.server.HttpServerAioHandler;
import org.tio.http.server.HttpServerAioListener;
import org.tio.server.ServerGroupContext;
import org.tio.server.TioServer;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;
import org.tio.utils.Threads;
import org.tio.utils.cache.ICache;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.http.HttpUtils;
import org.tio.utils.hutool.FileUtil;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.Json;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class HttpServerStarter {
    private static Logger log = LoggerFactory.getLogger(HttpServerStarter.class);
    private HttpConfig httpConfig = null;
    private HttpServerAioHandler httpServerAioHandler = null;
    private HttpServerAioListener httpServerAioListener = null;
    private ServerGroupContext serverGroupContext = null;
    private TioServer tioServer = null;
    private HttpRequestHandler httpRequestHandler = null;
    private List<String> preAccessFileType = new ArrayList<String>();

    public HttpServerStarter(HttpConfig httpConfig, HttpRequestHandler requestHandler) {
        this(httpConfig, requestHandler, null, null);
    }

    public HttpServerStarter(HttpConfig httpConfig, HttpRequestHandler requestHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this.preAccessFileType.add("html");
        this.preAccessFileType.add("ftl");
        if (tioExecutor == null) {
            tioExecutor = Threads.getTioExecutor();
        }
        if (groupExecutor == null) {
            groupExecutor = Threads.getGroupExecutor();
        }
        this.init(httpConfig, requestHandler, tioExecutor, groupExecutor);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HttpRequestHandler getHttpRequestHandler() {
        return this.httpRequestHandler;
    }

    public HttpServerAioHandler getHttpServerAioHandler() {
        return this.httpServerAioHandler;
    }

    public HttpServerAioListener getHttpServerAioListener() {
        return this.httpServerAioListener;
    }

    public ServerGroupContext getServerGroupContext() {
        return this.serverGroupContext;
    }

    private void init(HttpConfig httpConfig, HttpRequestHandler requestHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        String system_timer_period = System.getProperty("tio.system.timer.period");
        if (StrUtil.isBlank((CharSequence)system_timer_period)) {
            System.setProperty("tio.system.timer.period", "50");
        }
        this.httpConfig = httpConfig;
        this.httpRequestHandler = requestHandler;
        httpConfig.setHttpRequestHandler(this.httpRequestHandler);
        this.httpServerAioHandler = new HttpServerAioHandler(httpConfig, requestHandler);
        this.httpServerAioListener = new HttpServerAioListener();
        String name = httpConfig.getName();
        if (StrUtil.isBlank((CharSequence)name)) {
            name = "Tio Http Server";
        }
        this.serverGroupContext = new ServerGroupContext(name, (ServerAioHandler)this.httpServerAioHandler, (ServerAioListener)this.httpServerAioListener, tioExecutor, groupExecutor);
        this.serverGroupContext.setHeartbeatTimeout(20000L);
        this.serverGroupContext.setShortConnection(true);
        this.serverGroupContext.setReadBufferSize(132476);
        this.serverGroupContext.setAttribute("TIO_HTTP_REQ_HANDLER", (Object)this.httpRequestHandler);
        this.tioServer = new TioServer(this.serverGroupContext);
        HttpUuid imTioUuid = new HttpUuid();
        this.serverGroupContext.setTioUuid((TioUuid)imTioUuid);
    }

    public void setHttpRequestHandler(HttpRequestHandler requestHandler) {
        this.httpRequestHandler = requestHandler;
    }

    public void start() throws IOException {
        this.start(false);
    }

    public void start(boolean preAccess) throws IOException {
        if (this.httpConfig.isUseSession()) {
            if (this.httpConfig.getSessionStore() == null) {
                CaffeineCache caffeineCache = CaffeineCache.register((String)this.httpConfig.getSessionCacheName(), null, (Long)this.httpConfig.getSessionTimeout());
                this.httpConfig.setSessionStore((ICache)caffeineCache);
            }
            if (this.httpConfig.getSessionIdGenerator() == null) {
                this.httpConfig.setSessionIdGenerator((ISessionIdGenerator)UUIDSessionIdGenerator.instance);
            }
        }
        this.tioServer.start(this.httpConfig.getBindIp(), this.httpConfig.getBindPort().intValue());
        if (preAccess) {
            this.preAccess();
        }
    }

    public void preAccess() {
        if (this.httpConfig.isPageInClasspath()) {
            log.info("\u6682\u65f6\u53ea\u652f\u6301\u76ee\u5f55\u5f62\u5f0f\u7684\u9884\u8bbf\u95ee");
            return;
        }
        final String pageRoot = this.httpConfig.getPageRoot();
        if (pageRoot == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                TreeMap pathCostMap = new TreeMap();
                long start = System.currentTimeMillis();
                HttpServerStarter.this.preAccess(pageRoot, pathCostMap);
                long end = System.currentTimeMillis();
                long iv = end - start;
                TreeMap<Long, TreeSet<String>> costPathsMap = new TreeMap<Long, TreeSet<String>>(new Comparator<Long>(){

                    @Override
                    public int compare(Long o1, Long o2) {
                        return Long.compare(o2, o1);
                    }
                });
                Set entrySet = pathCostMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    try {
                        boolean added;
                        Long cost = (Long)entry.getValue();
                        String path = (String)entry.getKey();
                        TreeSet<String> pathSet = (TreeSet<String>)costPathsMap.get(cost);
                        if (pathSet == null) {
                            pathSet = new TreeSet<String>();
                            costPathsMap.put(cost, pathSet);
                        }
                        if (added = pathSet.add(path)) continue;
                        log.error("\u53ef\u80fd\u91cd\u590d\u8bbf\u95ee\u4e86:{}", (Object)path);
                    }
                    catch (Exception e) {
                        log.error(e.toString(), (Throwable)e);
                    }
                }
                log.info("\u9884\u8bbf\u95ee\u4e86{}\u4e2apath\uff0c\u8017\u65f6:{}ms\uff0c\u8bbf\u95ee\u8be6\u60c5:\r\n{}\r\n\u8017\u65f6\u6392\u5e8f:\r\n{}", new Object[]{pathCostMap.size(), iv, Json.toFormatedJson(pathCostMap), Json.toFormatedJson(costPathsMap)});
            }
        }).start();
    }

    private void preAccess(String rootpath, Map<String, Long> pathCostMap) {
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("host", "127.0.0.1");
            String protocol = null;
            protocol = this.serverGroupContext.isSsl() ? "https" : "http";
            String completePathPrefix = protocol + "://127.0.0.1:" + this.httpConfig.getBindPort();
            File rootDir = new File(rootpath);
            File[] files = rootDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String filename = file.getName();
                    String extension = FileUtil.extName((String)filename);
                    if (file.isDirectory()) {
                        return !"svn-base".equalsIgnoreCase(extension);
                    }
                    String ext = FileUtil.extName((File)file);
                    return HttpServerStarter.this.preAccessFileType.contains(ext);
                }
            });
            File pageRootFile = new File(this.httpConfig.getPageRoot());
            String pageRootAbs = pageRootFile.getCanonicalPath();
            for (File file : files) {
                try {
                    if (file.isDirectory()) {
                        this.preAccess(file.getCanonicalPath(), pathCostMap);
                        continue;
                    }
                    String absPath = file.getCanonicalPath();
                    log.info("pageRoot:{}, \u9884\u8bbf\u95ee\u8def\u5f84getAbsolutePath:{}", (Object)this.httpConfig.getPageRoot(), (Object)absPath);
                    long start = System.currentTimeMillis();
                    String path = absPath.substring(pageRootAbs.length());
                    if (!path.startsWith("/") && !path.startsWith("\\")) {
                        path = "/" + path;
                    }
                    log.info("\u9884\u8bbf\u95ee\u8def\u5f84:{}", (Object)path);
                    String url = completePathPrefix + path;
                    Response response = HttpUtils.get((String)url, headerMap);
                    long end = System.currentTimeMillis();
                    long iv = end - start;
                    pathCostMap.put(path, iv);
                    log.info("\u9884\u8bbf\u95ee\u5b8c\u6210\uff0c\u8017\u65f6{}ms, [{}], {}", new Object[]{iv, path, response});
                    response.close();
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
            }
        }
        catch (Exception e) {
            log.error("\u9884\u8bbf\u95ee\u62a5\u9519", (Throwable)e);
        }
    }

    public void stop() throws IOException {
        this.tioServer.stop();
    }

    public TioServer getTioServer() {
        return this.tioServer;
    }
}

