/*
	Apache License
	Version 2.0, January 2004
	http://www.apache.org/licenses/
	
	TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
	
	1. Definitions.
	
	"License" shall mean the terms and conditions for use, reproduction, and
	distribution as defined by Sections 1 through 9 of this document.
	
	"Licensor" shall mean the copyright owner or entity authorized by the copyright
	owner that is granting the License.
	
	"Legal Entity" shall mean the union of the acting entity and all other entities
	that control, are controlled by, or are under common control with that entity.
	For the purposes of this definition, "control" means (i) the power, direct or
	indirect, to cause the direction or management of such entity, whether by
	contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the
	outstanding shares, or (iii) beneficial ownership of such entity.
	
	"You" (or "Your") shall mean an individual or Legal Entity exercising
	permissions granted by this License.
	
	"Source" form shall mean the preferred form for making modifications, including
	but not limited to software source code, documentation source, and configuration
	files.
	
	"Object" form shall mean any form resulting from mechanical transformation or
	translation of a Source form, including but not limited to compiled object code,
	generated documentation, and conversions to other media types.
	
	"Work" shall mean the work of authorship, whether in Source or Object form, made
	available under the License, as indicated by a copyright notice that is included
	in or attached to the work (an example is provided in the Appendix below).
	
	"Derivative Works" shall mean any work, whether in Source or Object form, that
	is based on (or derived from) the Work and for which the editorial revisions,
	annotations, elaborations, or other modifications represent, as a whole, an
	original work of authorship. For the purposes of this License, Derivative Works
	shall not include works that remain separable from, or merely link (or bind by
	name) to the interfaces of, the Work and Derivative Works thereof.
	
	"Contribution" shall mean any work of authorship, including the original version
	of the Work and any modifications or additions to that Work or Derivative Works
	thereof, that is intentionally submitted to Licensor for inclusion in the Work
	by the copyright owner or by an individual or Legal Entity authorized to submit
	on behalf of the copyright owner. For the purposes of this definition,
	"submitted" means any form of electronic, verbal, or written communication sent
	to the Licensor or its representatives, including but not limited to
	communication on electronic mailing lists, source code control systems, and
	issue tracking systems that are managed by, or on behalf of, the Licensor for
	the purpose of discussing and improving the Work, but excluding communication
	that is conspicuously marked or otherwise designated in writing by the copyright
	owner as "Not a Contribution."
	
	"Contributor" shall mean Licensor and any individual or Legal Entity on behalf
	of whom a Contribution has been received by Licensor and subsequently
	incorporated within the Work.
	
	2. Grant of Copyright License.
	
	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable copyright license to reproduce, prepare Derivative Works of,
	publicly display, publicly perform, sublicense, and distribute the Work and such
	Derivative Works in Source or Object form.
	
	3. Grant of Patent License.
	
	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable (except as stated in this section) patent license to make, have
	made, use, offer to sell, sell, import, and otherwise transfer the Work, where
	such license applies only to those patent claims licensable by such Contributor
	that are necessarily infringed by their Contribution(s) alone or by combination
	of their Contribution(s) with the Work to which such Contribution(s) was
	submitted. If You institute patent litigation against any entity (including a
	cross-claim or counterclaim in a lawsuit) alleging that the Work or a
	Contribution incorporated within the Work constitutes direct or contributory
	patent infringement, then any patent licenses granted to You under this License
	for that Work shall terminate as of the date such litigation is filed.
	
	4. Redistribution.
	
	You may reproduce and distribute copies of the Work or Derivative Works thereof
	in any medium, with or without modifications, and in Source or Object form,
	provided that You meet the following conditions:
	
	You must give any other recipients of the Work or Derivative Works a copy of
	this License; and
	You must cause any modified files to carry prominent notices stating that You
	changed the files; and
	You must retain, in the Source form of any Derivative Works that You distribute,
	all copyright, patent, trademark, and attribution notices from the Source form
	of the Work, excluding those notices that do not pertain to any part of the
	Derivative Works; and
	If the Work includes a "NOTICE" text file as part of its distribution, then any
	Derivative Works that You distribute must include a readable copy of the
	attribution notices contained within such NOTICE file, excluding those notices
	that do not pertain to any part of the Derivative Works, in at least one of the
	following places: within a NOTICE text file distributed as part of the
	Derivative Works; within the Source form or documentation, if provided along
	with the Derivative Works; or, within a display generated by the Derivative
	Works, if and wherever such third-party notices normally appear. The contents of
	the NOTICE file are for informational purposes only and do not modify the
	License. You may add Your own attribution notices within Derivative Works that
	You distribute, alongside or as an addendum to the NOTICE text from the Work,
	provided that such additional attribution notices cannot be construed as
	modifying the License.
	You may add Your own copyright statement to Your modifications and may provide
	additional or different license terms and conditions for use, reproduction, or
	distribution of Your modifications, or for any such Derivative Works as a whole,
	provided Your use, reproduction, and distribution of the Work otherwise complies
	with the conditions stated in this License.
	
	5. Submission of Contributions.
	
	Unless You explicitly state otherwise, any Contribution intentionally submitted
	for inclusion in the Work by You to the Licensor shall be under the terms and
	conditions of this License, without any additional terms or conditions.
	Notwithstanding the above, nothing herein shall supersede or modify the terms of
	any separate license agreement you may have executed with Licensor regarding
	such Contributions.
	
	6. Trademarks.
	
	This License does not grant permission to use the trade names, trademarks,
	service marks, or product names of the Licensor, except as required for
	reasonable and customary use in describing the origin of the Work and
	reproducing the content of the NOTICE file.
	
	7. Disclaimer of Warranty.
	
	Unless required by applicable law or agreed to in writing, Licensor provides the
	Work (and each Contributor provides its Contributions) on an "AS IS" BASIS,
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied,
	including, without limitation, any warranties or conditions of TITLE,
	NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are
	solely responsible for determining the appropriateness of using or
	redistributing the Work and assume any risks associated with Your exercise of
	permissions under this License.
	
	8. Limitation of Liability.
	
	In no event and under no legal theory, whether in tort (including negligence),
	contract, or otherwise, unless required by applicable law (such as deliberate
	and grossly negligent acts) or agreed to in writing, shall any Contributor be
	liable to You for damages, including any direct, indirect, special, incidental,
	or consequential damages of any character arising as a result of this License or
	out of the use or inability to use the Work (including but not limited to
	damages for loss of goodwill, work stoppage, computer failure or malfunction, or
	any and all other commercial damages or losses), even if such Contributor has
	been advised of the possibility of such damages.
	
	9. Accepting Warranty or Additional Liability.
	
	While redistributing the Work or Derivative Works thereof, You may choose to
	offer, and charge a fee for, acceptance of support, warranty, indemnity, or
	other liability obligations and/or rights consistent with this License. However,
	in accepting such obligations, You may act only on Your own behalf and on Your
	sole responsibility, not on behalf of any other Contributor, and only if You
	agree to indemnify, defend, and hold each Contributor harmless for any liability
	incurred by, or claims asserted against, such Contributor by reason of your
	accepting any such warranty or additional liability.
	
	END OF TERMS AND CONDITIONS
	
	APPENDIX: How to apply the Apache License to your work
	
	To apply the Apache License to your work, attach the following boilerplate
	notice, with the fields enclosed by brackets "{}" replaced with your own
	identifying information. (Don't include the brackets!) The text should be
	enclosed in the appropriate comment syntax for the file format. We also
	recommend that a file or class name and description of purpose be included on
	the same "printed page" as the copyright notice for easier identification within
	third-party archives.
	
	   Copyright 2020 t-io
	
	   Licensed under the Apache License, Version 2.0 (the "License");
	   you may not use this file except in compliance with the License.
	   You may obtain a copy of the License at
	
	     http://www.apache.org/licenses/LICENSE-2.0
	
	   Unless required by applicable law or agreed to in writing, software
	   distributed under the License is distributed on an "AS IS" BASIS,
	   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	   See the License for the specific language governing permissions and
	   limitations under the License.
*/
package org.tio.http.server.mvc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeMap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.http.server.mvc.intf.ControllerFactory;
import org.tio.utils.hutool.ArrayUtil;
import org.tio.utils.hutool.ClassScanAnnotationHandler;
import org.tio.utils.hutool.ClassUtil;
import org.tio.utils.hutool.FileUtil;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.Json;

import com.esotericsoftware.reflectasm.MethodAccess;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.Paranamer;

/**
 * @author tanyaowu
 * 2017年7月1日 上午9:05:30
 */
public class Routes {
	private static Logger log = LoggerFactory.getLogger(Routes.class);

	/**
	 * 
	 */
	public static final String META_PATH_KEY = "TIO_HTTP_META_PATH";

//	private boolean writeMappingToFile = true;

	/**
	 * 路径和对象映射<br>
	 * key: /user<br>
	 * value: object<br>
	 */
	public final Map<String, Object> PATH_BEAN_MAP = new TreeMap<>();

	/**
	 * class和对象映射<br>
	 * key: XxxController.class<br>
	 * value: XxxController.class对应的实例对象<br>
	 */
	public static final Map<Class<?>, Object> CLASS_BEAN_MAP = new HashMap<>();

	/**
	 * bean和MethodAccess映射<br>
	 * key: XxxController.class对应的实例对象<br>
	 * value: MethodAccess<br>
	 */
	public static final Map<Object, MethodAccess> BEAN_METHODACCESS_MAP = new HashMap<>();

	/**
	 * 路径和class映射<br>
	 * 只是用来打印的<br>
	 * key: /user<br>
	 * value: Class<br>
	 */
	public final Map<String, Class<?>> PATH_CLASS_MAP = new TreeMap<>();

	/**
	 * 路径和class映射<br>
	 * key: class<br>
	 * value: /user<br>
	 */
	public static final Map<Class<?>, String> CLASS_PATH_MAP = new HashMap<>();

	/**
	 * Method路径映射<br>
	 * key: /user/update，包含forward的路径<br>
	 * value: method<br>
	 */
	public final Map<String, Method> PATH_METHOD_MAP = new TreeMap<>();

	/**
	 * 方法参数名映射<br>
	 * key: method<br>
	 * value: ["id", "name", "scanPackages"]<br>
	 */
	public final Map<Method, String[]> METHOD_PARAMNAME_MAP = new HashMap<>();

	/**
	 * path跟forward映射<br>
	 * key: 原访问路径<br>
	 * value: forward后的路径<br>
	 * 譬如：原来的访问路径是/user/123，forward是/user/getById，这个相当于是一个rewrite的功能，对外路径要相对友好，对内路径一般用于业务更便捷地处理
	 */
	public final Map<String, String> PATH_FORWARD_MAP = new HashMap<>();

	/**
	 * 方法和参数类型映射<br>
	 * key: method<br>
	 * value: [String.class, int.class]<br>
	 */
	public final Map<Method, Class<?>[]> METHOD_PARAMTYPE_MAP = new HashMap<>();

	/**
	 * 方法和对象映射<br>
	 * key: method<br>
	 * value: bean<br>
	 */
	public final Map<Method, Object> METHOD_BEAN_MAP = new HashMap<>();

	/**
	 * Method路径映射<br>
	 * 只是用于打印日志<br>
	 * key: /user/update<br>
	 * value: method string<br>
	 */
	public final Map<String, String> PATH_METHODSTR_MAP = new TreeMap<>();

	/**
	 * 含有路径变量的请求<br>
	 * key: 子路径的个数（pathUnitCount），譬如/user/{userid}就是2<br>
	 * value: VariablePathVo<br>
	 */
	public final Map<Integer, VariablePathVo[]> VARIABLE_PATH_MAP = new TreeMap<>();

	/**
	 * 含有路径变量的请求<br>
	 * 只是用于打印日志<br>
	 * key: 配置的路径/user/{userid}<br>
	 * value: method string<br>
	 */
	public final Map<String, String> VARIABLEPATH_METHODSTR_MAP = new TreeMap<>();

	private final StringBuilder errorStr = new StringBuilder();

	/**
	 * 
	 * @param scanPackages
	 */
	public Routes(String[] scanPackages) {
		this(scanPackages, null);
	}

	public Routes(String scanPackage) {
		this(scanPackage, null);
	}

	public Routes(String[] scanPackages, ControllerFactory controllerFactory) {
		addRoutes(scanPackages, controllerFactory);
	}

	public Routes(String scanPackage, ControllerFactory controllerFactory) {
		this(new String[] { scanPackage }, controllerFactory);
	}

	//
	public Routes(Class<?>[] scanRootClasses) {
		this(toPackages(scanRootClasses), null);
	}

	public Routes(Class<?> scanRootClasse) {
		this(scanRootClasse.getPackage().getName(), null);
	}

	public Routes(Class<?>[] scanRootClasses, ControllerFactory controllerFactory) {
		addRoutes(toPackages(scanRootClasses), controllerFactory);
	}

	public Routes(Class<?> scanRootClasse, ControllerFactory controllerFactory) {
		this(new String[] { scanRootClasse.getPackage().getName() }, controllerFactory);
	}

	public static String[] toPackages(Class<?>[] scanRootClasses) {
		String[] scanPackages = new String[scanRootClasses.length];
		int i = 0;
		for (Class<?> clazz : scanRootClasses) {
			scanPackages[i++] = clazz.getPackage().getName();
		}
		return scanPackages;
	}

	/**
	 * 添加路由
	 * @param scanPackages
	 * @author tanyaowu
	 */
	public void addRoutes(String[] scanPackages) {
		addRoutes(scanPackages, null);
	}

	/**
	 * 添加路由
	 * @param scanPackages
	 * @param controllerFactory
	 * @author tanyaowu
	 */
	public void addRoutes(String[] scanPackages, ControllerFactory controllerFactory) {
		if (controllerFactory == null) {
			controllerFactory = DefaultControllerFactory.me;
		}
		ControllerFactory controllerFactory1 = controllerFactory;
		if (scanPackages != null) {
			for (String pkg : scanPackages) {
				try {
					ClassUtil.scanPackage(pkg, new ClassScanAnnotationHandler(RequestPath.class) {
						@Override
						public void handlerAnnotation(Class<?> clazz) {
							try {
								Object bean = controllerFactory1.getInstance(clazz);//classWithAnnotation.newInstance();
								RequestPath classMapping = clazz.getAnnotation(RequestPath.class);
								String beanPath = classMapping.value();
								Object obj = PATH_BEAN_MAP.get(beanPath);
								if (obj != null) {
									log.error("mapping[{}] already exists in class [{}]", beanPath, obj.getClass().getName());
									errorStr.append("mapping[" + beanPath + "] already exists in class [" + obj.getClass().getName() + "]\r\n\r\n");
								} else {
									PATH_BEAN_MAP.put(beanPath, bean);
									CLASS_BEAN_MAP.put(clazz, bean);
									PATH_CLASS_MAP.put(beanPath, clazz);
									CLASS_PATH_MAP.put(clazz, beanPath);

									MethodAccess access = MethodAccess.get(clazz);
									BEAN_METHODACCESS_MAP.put(bean, access);
								}

								Method[] methods = clazz.getDeclaredMethods();//ClassUtil.getPublicMethods(clazz);
								c: for (Method method : methods) {
									int modifiers = method.getModifiers();
									if (!Modifier.isPublic(modifiers)) {
										continue c;
									}

									RequestPath mapping = method.getAnnotation(RequestPath.class);
									if (mapping == null) {
										//										log.error(method.getName());
										continue c;
									}

									//									String methodName = method.getName();
									String methodPath = mapping.value();
									//									if (StrUtil.isBlank(beanPath)) {
									//										log.error("方法有注解，但类没注解, method:{}, class:{}", methodName, clazz);
									//										errorStr.append("方法有注解，但类没注解, method:" + methodName + ", class:" + clazz + "\r\n\r\n");
									//										continue c;
									//									}

									String completePath = beanPath + methodPath;
									Class<?>[] parameterTypes = method.getParameterTypes();
									try {
										Paranamer paranamer = new BytecodeReadingParanamer();
										String[] parameterNames = paranamer.lookupParameterNames(method, false); // will return null if not found

										Method checkMethod = PATH_METHOD_MAP.get(completePath);
										if (checkMethod != null) {
											log.error("mapping[{}] already exists in method [{}]", completePath, checkMethod.getDeclaringClass() + "#" + checkMethod.getName());
											errorStr.append("mapping[" + completePath + "] already exists in method [" + checkMethod.getDeclaringClass() + "#"
											        + checkMethod.getName() + "]\r\n\r\n");
											continue c;
										}

										PATH_METHOD_MAP.put(completePath, method);

										String methodStr = methodToStr(method, parameterNames);
										PATH_METHODSTR_MAP.put(completePath, methodStr);

										METHOD_PARAMNAME_MAP.put(method, parameterNames);
										METHOD_PARAMTYPE_MAP.put(method, parameterTypes);
										if (StrUtil.isNotBlank(mapping.forward())) {
											PATH_FORWARD_MAP.put(completePath, mapping.forward());
											PATH_METHODSTR_MAP.put(mapping.forward(), methodStr);
											PATH_METHOD_MAP.put(mapping.forward(), method);
										}

										METHOD_BEAN_MAP.put(method, bean);
									} catch (Throwable e) {
										log.error(e.toString(), e);
									}
								}
							} catch (Throwable e) {
								log.error(e.toString(), e);
							}

						}
					});
				} catch (Exception e) {
					log.error(e.toString(), e);
				}

			}

			String pathClassMapStr = Json.toFormatedJson(PATH_CLASS_MAP);
			log.info("class  mapping\r\n{}", pathClassMapStr);
			String pathMethodstrMapStr = Json.toFormatedJson(PATH_METHODSTR_MAP);
			log.info("method mapping\r\n{}", pathMethodstrMapStr);

			processVariablePath();

			String variablePathMethodstrMapStr = Json.toFormatedJson(VARIABLEPATH_METHODSTR_MAP);
			log.info("variable path mapping\r\n{}", variablePathMethodstrMapStr);

			String writeMappingToFile = System.getProperty("tio.mvc.route.writeMappingToFile", "true");
			if ("true".equalsIgnoreCase(writeMappingToFile)) {
				try {
					FileUtil.writeString(pathClassMapStr, "/tio_mvc_path_class.json", "utf-8");
					FileUtil.writeString(pathMethodstrMapStr, "/tio_mvc_path_method.json", "utf-8");
					FileUtil.writeString(variablePathMethodstrMapStr, "/tio_mvc_variablepath_method.json", "utf-8");
					if (errorStr.length() > 0) {
						FileUtil.writeString(errorStr.toString(), "/tio_error_mvc.txt", "utf-8");
					}
				} catch (Exception e) {
					//										log.error(e.toString(), e);
				}
			}
		}
	}

	/**
	 * 处理有变量的路径
	 * @param PATH_METHOD_MAP
	 */
	private void processVariablePath() {
		Set<Entry<String, Method>> set = PATH_METHOD_MAP.entrySet();
		//		Set<String> forRemoved = new HashSet<>();
		for (Entry<String, Method> entry : set) {
			String path = entry.getKey();
			Method method = entry.getValue();
			if (StrUtil.contains(path, '{') && StrUtil.contains(path, '}')) {
				String[] pathUnits = StrUtil.split(path, "/");
				PathUnitVo[] pathUnitVos = new PathUnitVo[pathUnits.length];

				boolean isVarPath = false; //是否是带变量的路径
				for (int i = 0; i < pathUnits.length; i++) {
					PathUnitVo pathUnitVo = new PathUnitVo();
					String pathUnit = pathUnits[i];
					if (StrUtil.contains(pathUnit, '{') || StrUtil.contains(pathUnit, '}')) {
						if (StrUtil.startWith(pathUnit, "{") && StrUtil.endWith(pathUnit, "}")) {
							String[] xx = METHOD_PARAMNAME_MAP.get(method);
							String varName = StrUtil.subBetween(pathUnit, "{", "}");
							if (ArrayUtil.contains(xx, varName)) {
								isVarPath = true;
								pathUnitVo.setVar(true);
								pathUnitVo.setPath(varName);
							} else {
								log.error("path:{}, 对应的方法中并没有包含参数名为{}的参数", path, varName);
								errorStr.append("path:{" + path + "}, 对应的方法中并没有包含参数名为" + varName + "的参数\r\n\r\n");
							}
						} else {
							pathUnitVo.setVar(false);
							pathUnitVo.setPath(pathUnit);
						}
					} else {
						pathUnitVo.setVar(false);
						pathUnitVo.setPath(pathUnit);
					}
					pathUnitVos[i] = pathUnitVo;
				}

				if (isVarPath) {
					VariablePathVo variablePathVo = new VariablePathVo(path, method, pathUnitVos);
					addVariablePathVo(pathUnits.length, variablePathVo);
				}
			}
		}

		//		set.removeAll(forRemoved);
	}

	/**
	 * 
	 * @param pathUnitCount
	 * @param forceCreate
	 * @return
	 */
	@SuppressWarnings("unused")
	private VariablePathVo[] getVariablePathVos(Integer pathUnitCount, boolean forceCreate) {
		VariablePathVo[] ret = VARIABLE_PATH_MAP.get(pathUnitCount);
		if (forceCreate && ret == null) {
			ret = new VariablePathVo[0];
			VARIABLE_PATH_MAP.put(pathUnitCount, ret);
		}
		return ret;
	}

	/**
	 * 根据class获取class对应的bean
	 * @param <T>
	 * @param clazz
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static <T> T getController(Class<T> clazz) {
		return (T) CLASS_BEAN_MAP.get(clazz);
	}

	public static String getRequestPath(Class<?> clazz) {
		return CLASS_PATH_MAP.get(clazz);
	}

	/**
	 * 
	 * @param pathUnitCount
	 * @param variablePathVo
	 */
	private void addVariablePathVo(Integer pathUnitCount, VariablePathVo variablePathVo) {
		VariablePathVo[] existValue = VARIABLE_PATH_MAP.get(pathUnitCount);
		if (existValue == null) {
			existValue = new VariablePathVo[] { variablePathVo };
			VARIABLE_PATH_MAP.put(pathUnitCount, existValue);
		} else {
			VariablePathVo[] newExistValue = new VariablePathVo[existValue.length + 1];
			System.arraycopy(existValue, 0, newExistValue, 0, existValue.length);
			newExistValue[newExistValue.length - 1] = variablePathVo;
			VARIABLE_PATH_MAP.put(pathUnitCount, newExistValue);
		}
		VARIABLEPATH_METHODSTR_MAP.put(variablePathVo.getPath(), methodToStr(variablePathVo.getMethod(), METHOD_PARAMNAME_MAP.get(variablePathVo.getMethod())));
		//org.tio.http.server.mvc.Routes.METHOD_PARAMNAME_MAP
	}

	private String methodToStr(Method method, String[] parameterNames) {
		return method.getDeclaringClass().getName() + "." + method.getName() + "(" + ArrayUtil.join(parameterNames, ",") + ")";
		//		matchingClass.getName() + "." + method.getName() + "(" + ArrayUtil.join(parameterNames, ",") + ")"
	}

	@SuppressWarnings("unused")
	public Method getMethodByPath(String path, HttpRequest request) {
		Method method = PATH_METHOD_MAP.get(path);
		if (method == null) {
			String[] pathUnitsOfRequest = StrUtil.split(path, "/"); // "/user/214" -- > ["user", "214"]
			VariablePathVo[] variablePathVos = VARIABLE_PATH_MAP.get(pathUnitsOfRequest.length);
			if (variablePathVos != null) {
				tag1: for (VariablePathVo variablePathVo : variablePathVos) {
					PathUnitVo[] pathUnitVos = variablePathVo.getPathUnits();
					tag2: for (int i = 0; i < pathUnitVos.length; i++) {
						PathUnitVo pathUnitVo = pathUnitVos[i];
						String pathUnitOfRequest = pathUnitsOfRequest[i];

						if (pathUnitVo.isVar()) {
							request.addParam(pathUnitVo.getPath(), pathUnitOfRequest);
						} else {
							if (!StrUtil.equals(pathUnitVo.getPath(), pathUnitOfRequest)) {
								continue tag1;
							}
						}
					}

					String metapath = variablePathVo.getPath();
					String forward = PATH_FORWARD_MAP.get(metapath);
					if (StrUtil.isNotBlank(forward)) {
						request.requestLine.path = forward;
					}
					method = variablePathVo.getMethod();
					return method;
				}
			}
			return null;
		} else {
			return method;
		}
	}
}
