/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.cache.caffeineredis.CaffeineRedisCache;
import org.tio.utils.lock.LockUtils;

public abstract class CacheUtils {
    private static Logger log = LoggerFactory.getLogger(CacheUtils.class);
    private static final String PREFIX_TIMETOLIVESECONDS = CacheUtils.class.getName() + "_live";
    private static final String PREFIX_TIMETOIDLESECONDS = CacheUtils.class.getName() + "_idle";
    private static final Object LOCK_FOR_GETCACHE = new Object();

    private CacheUtils() {
    }

    public static <T extends Serializable> T get(Long timeToLiveSeconds, Long timeToIdleSeconds, String cacheKey, FirsthandCreater<T> firsthandCreater) {
        return CacheUtils.get(timeToLiveSeconds, timeToIdleSeconds, cacheKey, false, firsthandCreater);
    }

    public static <T extends Serializable> T get(Long timeToLiveSeconds, Long timeToIdleSeconds, String cacheKey, boolean putTempToCacheIfNull, FirsthandCreater<T> firsthandCreater) {
        CaffeineCache cache = CacheUtils.getCaffeineCache(timeToLiveSeconds, timeToIdleSeconds);
        return CacheUtils.get(cache, cacheKey, putTempToCacheIfNull, firsthandCreater);
    }

    public static <T extends Serializable> T get(ICache cache, String cacheKey, FirsthandCreater<T> firsthandCreater) {
        return CacheUtils.get(cache, cacheKey, false, firsthandCreater);
    }

    private static <T extends Serializable> T getFromCacheOnly(ICache cache, String cacheKey) {
        return (T)cache.get(cacheKey);
    }

    public static <T extends Serializable> T get(ICache cache, String cacheKey, boolean putTempToCacheIfNull, FirsthandCreater<T> firsthandCreater) {
        return CacheUtils.get(cache, cacheKey, putTempToCacheIfNull, firsthandCreater, 60L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends Serializable> T get(ICache cache, String cacheKey, boolean putTempToCacheIfNull, FirsthandCreater<T> firsthandCreater, Long readTimeoutWithSeconds) {
        T ret = CacheUtils.getFromCacheOnly(cache, cacheKey);
        if (ret != null) {
            return ret;
        }
        String lockKey = cache.getCacheName() + cacheKey;
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock(lockKey, cache);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        boolean tryWrite = writeLock.tryLock();
        if (tryWrite) {
            try {
                ret = CacheUtils.getFromCacheOnly(cache, cacheKey);
                if (ret != null) {
                    T t = ret;
                    return t;
                }
                try {
                    ret = firsthandCreater.create();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (ret == null) {
                    if (!putTempToCacheIfNull) return ret;
                    cache.putTemporary(cacheKey, ICache.NULL_OBJ);
                    return ret;
                }
                cache.put(cacheKey, (Serializable)ret);
                return ret;
            }
            finally {
                writeLock.unlock();
            }
        }
        ReentrantReadWriteLock.ReadLock readLock = rwLock.readLock();
        boolean tryRead = false;
        try {
            if (readTimeoutWithSeconds == null || readTimeoutWithSeconds <= 0L) {
                readTimeoutWithSeconds = 60L;
            }
            tryRead = readLock.tryLock(readTimeoutWithSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error(e.toString(), (Throwable)e);
        }
        if (!tryRead) return null;
        try {
            ret = CacheUtils.getFromCacheOnly(cache, cacheKey);
            if (ret == null) return ret;
            T t = ret;
            return t;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CaffeineCache getCaffeineCache(Long timeToLiveSeconds, Long timeToIdleSeconds) {
        String cacheName = CacheUtils.getCacheName(timeToLiveSeconds, timeToIdleSeconds);
        CaffeineCache caffeineCache = CaffeineCache.getCache(cacheName, true);
        if (caffeineCache == null) {
            Object object = LOCK_FOR_GETCACHE;
            synchronized (object) {
                caffeineCache = CaffeineCache.getCache(cacheName, true);
                if (caffeineCache == null) {
                    caffeineCache = CaffeineCache.register(cacheName, timeToLiveSeconds, timeToIdleSeconds);
                }
            }
        }
        return caffeineCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CaffeineRedisCache getCaffeineRedisCache(RedissonClient redisson, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        String cacheName = CacheUtils.getCacheName(timeToLiveSeconds, timeToIdleSeconds);
        CaffeineRedisCache caffeineCache = CaffeineRedisCache.getCache(cacheName, true);
        if (caffeineCache == null) {
            Object object = LOCK_FOR_GETCACHE;
            synchronized (object) {
                caffeineCache = CaffeineRedisCache.getCache(cacheName, true);
                if (caffeineCache == null) {
                    caffeineCache = CaffeineRedisCache.register(redisson, cacheName, timeToLiveSeconds, timeToIdleSeconds);
                }
            }
        }
        return caffeineCache;
    }

    private static String getCacheName(Long timeToLiveSeconds, Long timeToIdleSeconds) {
        if (timeToLiveSeconds != null) {
            return PREFIX_TIMETOLIVESECONDS + timeToLiveSeconds;
        }
        if (timeToIdleSeconds != null) {
            return PREFIX_TIMETOIDLESECONDS + timeToIdleSeconds;
        }
        throw new RuntimeException("timeToLiveSeconds\u548ctimeToIdleSeconds\u4e0d\u5141\u8bb8\u540c\u65f6\u4e3a\u7a7a");
    }

    public static void main(String[] args) {
    }
}

