/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.lock;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.lock.ReadWriteLockHandler;

public class LockUtils {
    private static Logger log = LoggerFactory.getLogger(LockUtils.class);
    private static final String LOCK_TYPE_OBJ = "OBJ";
    private static final String LOCK_TYPE_RW = "RW";
    private static final Object defaultLockObjForObj = new Object();
    private static final Object defaultLockObjForRw = new Object();
    private static final CaffeineCache LOCAL_LOCKS = CaffeineCache.register(LockUtils.class.getName() + "OBJ", null, 3600L);
    private static final CaffeineCache LOCAL_READWRITE_LOCKS = CaffeineCache.register(LockUtils.class.getName() + "RW", null, 3600L);

    public static Serializable getLockObj(String key) {
        return LockUtils.getLockObj(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable getLockObj(String key, Object myLock) {
        Serializable lock = LOCAL_LOCKS.get(key);
        if (lock == null) {
            Object ml = myLock;
            if (ml == null) {
                ml = defaultLockObjForObj;
            }
            Object object = ml;
            synchronized (object) {
                lock = LOCAL_LOCKS.get(key);
                if (lock == null) {
                    lock = new Serializable(){
                        private static final long serialVersionUID = 255956860617836425L;
                    };
                    LOCAL_LOCKS.put(key, lock);
                }
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReentrantReadWriteLock getReentrantReadWriteLock(String key, Object myLock) {
        ReentrantReadWriteLock lock = (ReentrantReadWriteLock)LOCAL_READWRITE_LOCKS.get(key);
        if (lock == null) {
            Object ml = myLock;
            if (ml == null) {
                ml = defaultLockObjForRw;
            }
            Object object = ml;
            synchronized (object) {
                lock = (ReentrantReadWriteLock)LOCAL_READWRITE_LOCKS.get(key);
                if (lock == null) {
                    lock = new ReentrantReadWriteLock();
                    LOCAL_READWRITE_LOCKS.put(key, lock);
                }
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadWriteLockHandler.ReadWriteRet runReadOrWrite(String key, Object myLock, ReadWriteLockHandler readWriteLockHandler) throws Exception {
        ReadWriteLockHandler.ReadWriteRet ret;
        block9: {
            ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock(key, myLock);
            ret = new ReadWriteLockHandler.ReadWriteRet();
            ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
            boolean tryWrite = writeLock.tryLock();
            if (tryWrite) {
                try {
                    Object writeRet = readWriteLockHandler.write();
                    ret.isWriteRunned = true;
                    ret.writeRet = writeRet;
                }
                finally {
                    writeLock.unlock();
                }
            }
            ReentrantReadWriteLock.ReadLock readLock = rwLock.readLock();
            boolean tryRead = false;
            try {
                tryRead = readLock.tryLock(120L, TimeUnit.SECONDS);
                if (!tryRead) break block9;
                try {
                    Object readRet = readWriteLockHandler.read();
                    ret.isReadRunned = true;
                    ret.readRet = readRet;
                }
                finally {
                    readLock.unlock();
                }
            }
            catch (InterruptedException e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
        return ret;
    }
}

