/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.qr.scheme;

import java.util.ArrayList;
import java.util.List;
import org.tio.utils.qr.scheme.Schema;

public class GeoInfo
extends Schema {
    public static final String GEO = "geo";
    private List<String> points = new ArrayList<String>();

    public List<String> getPoints() {
        return this.points;
    }

    public void setPoints(List<String> points) {
        this.points = points;
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null || !code.trim().toLowerCase().startsWith(GEO)) {
            throw new IllegalArgumentException("this is not a geo info code: " + code);
        }
        String[] points = code.trim().toLowerCase().replaceAll("geo:", "").split(",");
        if (points != null && points.length > 0) {
            for (String point : points) {
                this.points.add(point);
            }
        }
        return this;
    }

    @Override
    public String generateString() {
        StringBuilder builder = new StringBuilder();
        if (this.points != null) {
            int s = this.points.size();
            for (int i = 0; i < s; ++i) {
                builder.append(this.points.get(i));
                if (i >= s - 1) continue;
                builder.append(",");
            }
        }
        return "geo:" + builder.toString();
    }

    public String toString() {
        return this.generateString();
    }

    public static GeoInfo parse(String geoInfoCode) {
        GeoInfo geoInfo = new GeoInfo();
        geoInfo.parseSchema(geoInfoCode);
        return geoInfo;
    }
}

