/*
 * Decompiled with CFR 0.152.
 */
package tachyon.hadoop;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.ClientContext;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.conf.TachyonConf;
import tachyon.hadoop.ConfUtils;
import tachyon.hadoop.HdfsFileInputStream;
import tachyon.hadoop.Utils;
import tachyon.thrift.FileBlockInfo;
import tachyon.thrift.FileInfo;
import tachyon.thrift.NetAddress;
import tachyon.util.CommonUtils;

abstract class AbstractTFS
extends FileSystem {
    public static final String FIRST_COM_PATH = "tachyon_dep/";
    public static final String RECOMPUTE_PATH = "tachyon_recompute/";
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private String mUnderFSAddress;
    private URI mUri = null;
    private Path mWorkingDir = new Path("/");
    private FileSystem.Statistics mStatistics = null;
    private TachyonFS mTFS = null;
    private String mTachyonHeader = null;
    private final TachyonConf mTachyonConf = ClientContext.getConf();

    AbstractTFS() {
    }

    public FSDataOutputStream append(Path cPath, int bufferSize, Progressable progress) throws IOException {
        TachyonURI path;
        long fileId;
        TachyonFile file;
        LOG.info("append(" + cPath + ", " + bufferSize + ", " + progress + ")");
        if (this.mStatistics != null) {
            this.mStatistics.incrementWriteOps(1);
        }
        if ((file = this.mTFS.getFile(fileId = this.mTFS.getFileId(path = new TachyonURI(Utils.getPathWithoutScheme(cPath))))).length() > 0L) {
            LOG.warn("This maybe an error.");
        }
        return new FSDataOutputStream((OutputStream)file.getOutStream(), this.mStatistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.mTFS != null) {
                this.mTFS.close();
            }
        }
    }

    public FSDataOutputStream create(Path cPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        TachyonURI path;
        LOG.info("create(" + cPath + ", " + permission + ", " + overwrite + ", " + bufferSize + ", " + replication + ", " + blockSize + ", " + progress + ")");
        if (this.mStatistics != null) {
            this.mStatistics.incrementWriteOps(1);
        }
        if (this.mTFS.exist(path = new TachyonURI(Utils.getPathWithoutScheme(cPath)))) {
            if (overwrite && !this.mTFS.getFileStatus((long)-1L, (TachyonURI)path).isFolder) {
                if (!this.mTFS.delete(path, false)) {
                    throw new IOException("Failed to delete existing data " + cPath);
                }
            } else {
                throw new IOException(cPath.toString() + " already exists. Directories cannot be " + "overwritten with create.");
            }
        }
        long fileId = this.mTFS.createFile(path, blockSize);
        TachyonFile file = this.mTFS.getFile(fileId);
        file.setUFSConf(this.getConf());
        return new FSDataOutputStream((OutputStream)file.getOutStream(), this.mStatistics);
    }

    @Deprecated
    public FSDataOutputStream createNonRecursive(Path cPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        TachyonURI path = new TachyonURI(Utils.getPathWithoutScheme(cPath.getParent()));
        if (!this.mTFS.exist(path)) {
            throw new FileNotFoundException("Parent directory does not exist!");
        }
        return this.create(cPath, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Deprecated
    public boolean delete(Path path) throws IOException {
        return this.delete(path, true);
    }

    public boolean delete(Path cPath, boolean recursive) throws IOException {
        TachyonURI path;
        LOG.info("delete(" + cPath + ", " + recursive + ")");
        if (this.mStatistics != null) {
            this.mStatistics.incrementWriteOps(1);
        }
        if (!this.mTFS.exist(path = new TachyonURI(Utils.getPathWithoutScheme(cPath)))) {
            return false;
        }
        boolean rtn = this.mTFS.delete(path, recursive);
        if (this.mTFS.exist(path)) {
            throw new IOException("Failed to delete path " + path.toString());
        }
        return rtn;
    }

    public long getDefaultBlockSize() {
        return this.mTachyonConf.getBytes("tachyon.user.block.size.bytes.default");
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        TachyonURI path;
        long fileId;
        if (file == null) {
            return null;
        }
        if (this.mStatistics != null) {
            this.mStatistics.incrementReadOps(1);
        }
        if ((fileId = this.mTFS.getFileId(path = new TachyonURI(Utils.getPathWithoutScheme(file.getPath())))) == -1L) {
            throw new FileNotFoundException("File does not exist: " + file.getPath());
        }
        ArrayList<BlockLocation> blockLocations = new ArrayList<BlockLocation>();
        List<FileBlockInfo> blocks = this.mTFS.getFileBlocks(fileId);
        for (int k = 0; k < blocks.size(); ++k) {
            FileBlockInfo info = blocks.get(k);
            long offset = info.getOffset();
            long end = offset + info.blockInfo.getLength();
            if (end < start || offset > start + len) continue;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> hosts = new ArrayList<String>();
            ArrayList addrs = Lists.newArrayList();
            for (tachyon.thrift.BlockLocation location : info.getBlockInfo().getLocations()) {
                addrs.add(location.getWorkerAddress());
            }
            addrs.addAll(info.getUfsLocations());
            for (NetAddress addr : addrs) {
                String name = addr.host + ":" + addr.dataPort;
                LOG.debug("getFileBlockLocations : adding name : '" + name + "");
                names.add(name);
                hosts.add(addr.host);
            }
            blockLocations.add(new BlockLocation(CommonUtils.toStringArray(names), CommonUtils.toStringArray(hosts), offset, info.blockInfo.getLength()));
        }
        BlockLocation[] ret = new BlockLocation[blockLocations.size()];
        blockLocations.toArray(ret);
        return ret;
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        TachyonFile file;
        TachyonURI tPath = new TachyonURI(Utils.getPathWithoutScheme(path));
        Path hdfsPath = Utils.getHDFSPath(tPath, this.mUnderFSAddress);
        LOG.info("getFileStatus(" + path + "): HDFS Path: " + hdfsPath + " TPath: " + this.mTachyonHeader + tPath);
        if (this.mStatistics != null) {
            this.mStatistics.incrementReadOps(1);
        }
        try {
            file = this.mTFS.getFile(tPath);
        }
        catch (IOException ioe) {
            LOG.info("File does not exist: " + path);
            throw new FileNotFoundException("File does not exist: " + path);
        }
        FileStatus ret = new FileStatus(file.length(), file.isDirectory(), file.getDiskReplication(), file.getBlockSizeByte(), file.getCreationTimeMs(), file.getCreationTimeMs(), null, null, null, new Path(this.mTachyonHeader + tPath));
        return ret;
    }

    public abstract String getScheme();

    public TachyonFS getTachyonFS() {
        return this.mTFS;
    }

    public URI getUri() {
        return this.mUri;
    }

    public Path getWorkingDirectory() {
        LOG.info("getWorkingDirectory: " + this.mWorkingDir);
        return this.mWorkingDir;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        LOG.info("initialize(" + uri + ", " + conf + "). Connecting to Tachyon: " + uri.toString());
        Utils.addS3Credentials(conf);
        this.setConf(conf);
        this.mTachyonHeader = this.getScheme() + "://" + uri.getHost() + ":" + uri.getPort();
        this.mStatistics = this.statistics;
        TachyonConf siteConf = ConfUtils.loadFromHadoopConfiguration(conf);
        if (siteConf != null) {
            this.mTachyonConf.merge(siteConf);
        }
        this.mTachyonConf.set("tachyon.master.hostname", uri.getHost());
        this.mTachyonConf.set("tachyon.master.port", Integer.toString(uri.getPort()));
        this.mTachyonConf.set("tachyon.zookeeper.enabled", Boolean.toString(this.isZookeeperMode()));
        this.mTFS = TachyonFS.get(this.mTachyonConf);
        this.mUri = URI.create(this.mTachyonHeader);
        this.mUnderFSAddress = this.mTFS.getUfsAddress();
        LOG.info(this.mTachyonHeader + " " + this.mUri + " " + this.mUnderFSAddress);
    }

    protected abstract boolean isZookeeperMode();

    public FileStatus[] listStatus(Path path) throws IOException {
        TachyonURI tPath = new TachyonURI(Utils.getPathWithoutScheme(path));
        Path hdfsPath = Utils.getHDFSPath(tPath, this.mUnderFSAddress);
        LOG.info("listStatus(" + path + "): HDFS Path: " + hdfsPath);
        if (this.mStatistics != null) {
            this.mStatistics.incrementReadOps(1);
        }
        if (!this.mTFS.exist(tPath)) {
            throw new FileNotFoundException("File does not exist: " + path);
        }
        List<FileInfo> files = this.mTFS.listStatus(tPath);
        FileStatus[] ret = new FileStatus[files.size()];
        for (int k = 0; k < files.size(); ++k) {
            FileInfo info = files.get(k);
            ret[k] = new FileStatus(info.getLength(), info.isFolder, 3, info.getBlockSizeBytes(), info.getCreationTimeMs(), info.getCreationTimeMs(), null, null, null, new Path(this.mTachyonHeader + info.getPath()));
        }
        return ret;
    }

    public boolean mkdirs(Path cPath, FsPermission permission) throws IOException {
        LOG.info("mkdirs(" + cPath + ", " + permission + ")");
        if (this.mStatistics != null) {
            this.mStatistics.incrementWriteOps(1);
        }
        TachyonURI path = new TachyonURI(Utils.getPathWithoutScheme(cPath));
        return this.mTFS.mkdir(path);
    }

    public FSDataInputStream open(Path cPath, int bufferSize) throws IOException {
        LOG.info("open(" + cPath + ", " + bufferSize + ")");
        if (this.mStatistics != null) {
            this.mStatistics.incrementReadOps(1);
        }
        TachyonURI path = new TachyonURI(Utils.getPathWithoutScheme(cPath));
        long fileId = this.mTFS.getFileId(path);
        return new FSDataInputStream((InputStream)new HdfsFileInputStream(this.mTFS, fileId, Utils.getHDFSPath(path, this.mUnderFSAddress), this.getConf(), bufferSize, this.mStatistics, this.mTachyonConf));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        FileInfo info;
        LOG.info("rename(" + src + ", " + dst + ")");
        if (this.mStatistics != null) {
            this.mStatistics.incrementWriteOps(1);
        }
        TachyonURI srcPath = new TachyonURI(Utils.getPathWithoutScheme(src));
        TachyonURI dstPath = new TachyonURI(Utils.getPathWithoutScheme(dst));
        try {
            info = this.mTFS.getFileStatus(-1L, dstPath);
        }
        catch (IOException ioe) {
            info = null;
        }
        if (info != null && info.isFolder) {
            dstPath = dstPath.join(srcPath.getName());
        }
        try {
            return this.mTFS.rename(srcPath, dstPath);
        }
        catch (IOException ioe) {
            LOG.error("Failed to rename {} to {}", new Object[]{src, dst, ioe});
            return false;
        }
    }

    public void setWorkingDirectory(Path path) {
        LOG.info("setWorkingDirectory(" + path + ")");
        this.mWorkingDir = path.isAbsolute() ? path : new Path(this.mWorkingDir, path);
    }
}

