/*
 * Decompiled with CFR 0.152.
 */
package tachyon.heartbeat;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.heartbeat.HeartbeatTimer;

public final class SleepingTimer
implements HeartbeatTimer {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final long mIntervalMs;
    private long mPreviousTickMs;
    private final String mThreadName;

    public SleepingTimer(String threadName, long intervalMs) {
        this.mIntervalMs = intervalMs;
        this.mThreadName = threadName;
    }

    @Override
    public void tick() throws InterruptedException {
        if (this.mPreviousTickMs == 0L) {
            Thread.sleep(this.mIntervalMs);
        } else {
            long executionTimeMs = System.currentTimeMillis() - this.mPreviousTickMs;
            if (executionTimeMs > this.mIntervalMs) {
                LOG.warn(this.mThreadName + " last execution took " + executionTimeMs + " ms. Longer than the interval " + this.mIntervalMs);
            } else {
                Thread.sleep(this.mIntervalMs - executionTimeMs);
            }
        }
        this.mPreviousTickMs = System.currentTimeMillis();
    }
}

