/*
 * Decompiled with CFR 0.152.
 */
package tachyon.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.network.protocol.RPCErrorResponse;
import tachyon.network.protocol.RPCMessage;
import tachyon.network.protocol.RPCResponse;

@ChannelHandler.Sharable
public final class RPCMessageDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);

    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        RPCMessage.Type type = RPCMessage.Type.decode(in);
        RPCMessage message = RPCMessage.decodeMessage(type, in);
        out.add(message);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Error in decoding message. Possible Client/DataServer version incompatibility: " + cause.getMessage());
        ctx.channel().writeAndFlush((Object)new RPCErrorResponse(RPCResponse.Status.DECODE_ERROR)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

