/*
 * Decompiled with CFR 0.152.
 */
package tachyon.security.authentication;

import javax.security.sasl.AuthenticationException;
import tachyon.conf.TachyonConf;
import tachyon.security.authentication.AuthType;
import tachyon.security.authentication.CustomAuthenticationProviderImpl;
import tachyon.security.authentication.SimpleAuthenticationProviderImpl;

public interface AuthenticationProvider {
    public void authenticate(String var1, String var2) throws AuthenticationException;

    public static class Factory {
        public static AuthenticationProvider getAuthenticationProvider(AuthType authType, TachyonConf conf) throws AuthenticationException {
            switch (authType) {
                case SIMPLE: {
                    return new SimpleAuthenticationProviderImpl();
                }
                case CUSTOM: {
                    String customProviderName = conf.get("tachyon.security.authentication.custom.provider.class");
                    return new CustomAuthenticationProviderImpl(customProviderName);
                }
            }
            throw new AuthenticationException("Unsupported AuthType: " + authType.getAuthName());
        }
    }
}

