/*
 * Decompiled with CFR 0.152.
 */
package tachyon.security.authentication;

import java.security.Provider;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import tachyon.security.authentication.PlainSaslServer;

public final class PlainSaslServerProvider
extends Provider {
    private static final long serialVersionUID = 4583558117355348638L;
    public static final String PROVIDER_NAME = "SaslPlain";
    public static final String MECHANISM = "PLAIN";
    public static final double PROVIDER_VERSION = 1.0;

    public PlainSaslServerProvider() {
        super(PROVIDER_NAME, 1.0, "Plain SASL server provider");
        this.put("SaslServerFactory.PLAIN", PlainSaslServerFactory.class.getName());
    }

    public static class PlainSaslServerFactory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler) throws SaslException {
            if (PlainSaslServerProvider.MECHANISM.equals(mechanism)) {
                return new PlainSaslServer(callbackHandler);
            }
            return null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return new String[]{PlainSaslServerProvider.MECHANISM};
        }
    }
}

