/*
 * Decompiled with CFR 0.152.
 */
package tachyon.org.jets3t.service.utils.signedurl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.contrib.proxy.PluginProxyUtil;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tachyon.org.jets3t.service.model.S3Object;
import tachyon.org.jets3t.service.utils.ServiceUtils;
import tachyon.org.jets3t.service.utils.gatekeeper.GatekeeperMessage;
import tachyon.org.jets3t.service.utils.gatekeeper.SignatureRequest;

public class GatekeeperClientUtils {
    private HttpClient httpClientGatekeeper = null;
    private static final Log log = LogFactory.getLog(GatekeeperClientUtils.class);
    private Exception priorFailureException = null;
    private String gatekeeperUrl = null;
    private String userAgentDescription;
    private int maxRetryCount;
    private int connectionTimeout;
    private CredentialsProvider credentialsProvider = null;

    public GatekeeperClientUtils(String gatekeeperUrl, String userAgentDescription, int maxRetryCount, int connectionTimeoutMS, CredentialsProvider credentialsProvider) {
        this.gatekeeperUrl = gatekeeperUrl;
        this.userAgentDescription = userAgentDescription;
        this.maxRetryCount = maxRetryCount;
        this.connectionTimeout = connectionTimeoutMS;
        this.credentialsProvider = credentialsProvider;
    }

    private HttpClient initHttpConnection() {
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setParameter("http.useragent", (Object)ServiceUtils.getUserAgentDescription(this.userAgentDescription));
        clientParams.setParameter("http.method.retry-handler", (Object)new HttpMethodRetryHandler(){

            public boolean retryMethod(HttpMethod httpMethod, IOException ioe, int executionCount) {
                if (executionCount > GatekeeperClientUtils.this.maxRetryCount) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Retried connection " + executionCount + " times, which exceeds the maximum retry count of " + GatekeeperClientUtils.this.maxRetryCount));
                    }
                    return false;
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Retrying request - attempt " + executionCount + " of " + GatekeeperClientUtils.this.maxRetryCount));
                }
                return true;
            }
        });
        HttpConnectionManagerParams connectionParams = new HttpConnectionManagerParams();
        connectionParams.setConnectionTimeout(this.connectionTimeout);
        connectionParams.setSoTimeout(this.connectionTimeout);
        connectionParams.setStaleCheckingEnabled(false);
        HttpClient httpClient = new HttpClient(clientParams);
        httpClient.getHttpConnectionManager().setParams(connectionParams);
        httpClient.getParams().setParameter("http.authentication.credential-provider", (Object)this.credentialsProvider);
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GatekeeperMessage requestActionThroughGatekeeper(String operationType, String bucketName, S3Object[] objects, Map applicationPropertiesMap) throws HttpException, Exception {
        PostMethod postMethod;
        block25: {
            GatekeeperMessage gatekeeperMessage = new GatekeeperMessage();
            gatekeeperMessage.addApplicationProperties(applicationPropertiesMap);
            gatekeeperMessage.addApplicationProperty("clientVersionId", this.userAgentDescription);
            if (this.priorFailureException != null) {
                gatekeeperMessage.addApplicationProperty("priorFailureMessage", this.priorFailureException.getMessage());
                this.priorFailureException = null;
            }
            for (int i = 0; i < objects.length; ++i) {
                SignatureRequest signatureRequest = new SignatureRequest(operationType, objects[i].getKey());
                signatureRequest.setObjectMetadata(objects[i].getMetadataMap());
                signatureRequest.setBucketName(bucketName);
                gatekeeperMessage.addSignatureRequest(signatureRequest);
            }
            postMethod = new PostMethod(this.gatekeeperUrl);
            Properties properties = gatekeeperMessage.encodeToProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String fieldName = (String)entry.getKey();
                String fieldValue = (String)entry.getValue();
                postMethod.setParameter(fieldName, fieldValue);
            }
            if (this.httpClientGatekeeper == null) {
                this.httpClientGatekeeper = this.initHttpConnection();
            }
            try {
                ProxyHost proxyHost = PluginProxyUtil.detectProxy((URL)new URL(this.gatekeeperUrl));
                if (proxyHost != null) {
                    HostConfiguration hostConfig = new HostConfiguration();
                    hostConfig.setProxyHost(proxyHost);
                    this.httpClientGatekeeper.setHostConfiguration(hostConfig);
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block25;
                log.debug((Object)"No proxy detected");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Contacting Gatekeeper at: " + this.gatekeeperUrl));
        }
        try {
            int responseCode = this.httpClientGatekeeper.executeMethod((HttpMethod)postMethod);
            String contentType = postMethod.getResponseHeader("Content-Type").getValue();
            if (responseCode == 200) {
                InputStream responseInputStream = null;
                Header encodingHeader = postMethod.getResponseHeader("Content-Encoding");
                if (encodingHeader != null && "gzip".equalsIgnoreCase(encodingHeader.getValue())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Inflating gzip-encoded response");
                    }
                    responseInputStream = new GZIPInputStream(postMethod.getResponseBodyAsStream());
                } else {
                    responseInputStream = postMethod.getResponseBodyAsStream();
                }
                if (responseInputStream == null) {
                    throw new IOException("No response input stream available from Gatekeeper");
                }
                Properties responseProperties = new Properties();
                try {
                    responseProperties.load(responseInputStream);
                }
                finally {
                    responseInputStream.close();
                }
                GatekeeperMessage gatekeeperResponseMessage = GatekeeperMessage.decodeFromProperties(responseProperties);
                String gatekeeperErrorCode = gatekeeperResponseMessage.getApplicationProperties().getProperty("gatekeeperErrorCode");
                if (gatekeeperErrorCode != null && log.isWarnEnabled()) {
                    log.warn((Object)("Received Gatekeeper error code: " + gatekeeperErrorCode));
                }
                GatekeeperMessage gatekeeperMessage = gatekeeperResponseMessage;
                return gatekeeperMessage;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The Gatekeeper did not permit a request. Response code: " + responseCode + ", Response content type: " + contentType));
                }
                throw new IOException("The Gatekeeper did not permit your request");
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Exception("Gatekeeper did not respond", e);
            }
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    public S3Object[] buildS3ObjectsFromSignatureRequests(SignatureRequest[] srs) {
        S3Object[] objects = new S3Object[srs.length];
        for (int i = 0; i < srs.length; ++i) {
            objects[i] = new S3Object(srs[i].getObjectKey());
            objects[i].addAllMetadata(srs[i].getObjectMetadata());
        }
        return objects;
    }

    public String getGatekeeperUrl() {
        return this.gatekeeperUrl;
    }
}

