/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client.internal;

import java.util.Collection;
import java.util.List;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.SLPropertiesImpl;
import org.talend.esb.servicelocator.client.internal.endpoint.EntryType;
import org.talend.esb.servicelocator.client.internal.endpoint.ObjectFactory;
import org.talend.esb.servicelocator.client.internal.endpoint.ServiceLocatorPropertiesType;

public final class SLPropertiesConverter {
    private SLPropertiesConverter() {
    }

    public static ServiceLocatorPropertiesType toServiceLocatorPropertiesType(SLProperties props) {
        ObjectFactory of = new ObjectFactory();
        ServiceLocatorPropertiesType slPropertiesType = of.createServiceLocatorPropertiesType();
        List<EntryType> entries = slPropertiesType.getEntry();
        for (String name : props.getPropertyNames()) {
            entries.add(SLPropertiesConverter.createEntry(props, name));
        }
        return slPropertiesType;
    }

    public static SLProperties toSLProperties(ServiceLocatorPropertiesType props) {
        SLPropertiesImpl slProperties = new SLPropertiesImpl();
        for (EntryType entry : props.getEntry()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            slProperties.addProperty(key, values);
        }
        return slProperties;
    }

    private static EntryType createEntry(SLProperties props, String name) {
        EntryType entry = new EntryType();
        entry.setKey(name);
        List<String> jaxbValues = entry.getValue();
        Collection<String> values = props.getValues(name);
        for (String value : values) {
            jaxbValues.add(value);
        }
        return entry;
    }
}

