/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.talend.esb.servicelocator.client.SLPropertiesMatcher;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.cxf.internal.LocatorCache;

public abstract class LocatorSelectionStrategy
implements FailoverStrategy {
    protected static final Logger LOG = Logger.getLogger(LocatorSelectionStrategy.class.getName());
    protected LocatorCache locatorCache = new LocatorCache();
    private Random random = new Random();

    public String selectAlternateAddress(List<String> alternates) {
        String alternateAddress = null;
        if (alternates != null && !alternates.isEmpty()) {
            int index = this.random.nextInt(alternates.size());
            alternateAddress = alternates.remove(index);
        }
        LOG.log(Level.INFO, "selectAlternateAddress  alternates = " + alternates + " alternateAddress = " + alternateAddress);
        return alternateAddress;
    }

    public List<String> getAlternateAddresses(Exchange exchange) {
        return this.locatorCache.getFailoverEndpoints(this.getServiceName(exchange));
    }

    public List<Endpoint> getAlternateEndpoints(Exchange exchange) {
        return null;
    }

    public Endpoint selectAlternateEndpoint(List<Endpoint> alternates) {
        return null;
    }

    public abstract String getPrimaryAddress(Exchange var1);

    public synchronized void setMatcher(SLPropertiesMatcher propertiesMatcher) {
        if (propertiesMatcher != null) {
            this.locatorCache.setMatcher(propertiesMatcher);
        }
    }

    public void setServiceLocator(ServiceLocator serviceLocator) {
        this.locatorCache.setServiceLocator(serviceLocator);
    }

    public void setReloadAddressesCount(int reloadAddressesCount) {
        this.locatorCache.setReloadCount(reloadAddressesCount);
    }

    protected QName getServiceName(Exchange exchange) {
        return exchange.getEndpoint().getService().getName();
    }
}

