/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.samenabling;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.talend.esb.policy.samenabling.SamEnablingPolicy;
import org.talend.esb.policy.samenabling.SamEnablingPolicyBuilder;
import org.talend.esb.sam.agent.feature.EventFeature;
import org.talend.esb.sam.agent.wiretap.WireTapIn;
import org.talend.esb.sam.agent.wiretap.WireTapOut;

public class SamEnablingInterceptorProvider
extends AbstractPolicyInterceptorProvider {
    private static final long serialVersionUID = 4595900233265934333L;
    private static final String AGENT_CONTEXT_PATH = "META-INF/tesb/agent-context.xml";
    private static ClassPathXmlApplicationContext springContext;
    private static RuntimeException springContextException;

    public SamEnablingInterceptorProvider() {
        super(Arrays.asList(SamEnablingPolicyBuilder.SAM_ENABLE));
        this.getOutInterceptors().add(new SAMEnableOutInterceptor());
        this.getOutFaultInterceptors().add(new SAMEnableOutInterceptor());
        this.getInInterceptors().add(new SAMEnableInInterceptor());
        this.getInFaultInterceptors().add(new SAMEnableInInterceptor());
        try {
            if (((Object)((Object)this)).getClass().getResource("/META-INF/tesb/agent-context.xml") != null) {
                springContext = new ClassPathXmlApplicationContext(new String[]{AGENT_CONTEXT_PATH});
            }
        }
        catch (RuntimeException e) {
            springContextException = e;
        }
    }

    static void process(Message message) {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (aim != null) {
            Collection ais = (Collection)aim.get((Object)SamEnablingPolicyBuilder.SAM_ENABLE);
            if (ais != null) {
                for (AssertionInfo ai : ais) {
                    EndpointInfo ei;
                    if (!(ai.getAssertion() instanceof SamEnablingPolicy)) continue;
                    SamEnablingPolicy vPolicy = (SamEnablingPolicy)ai.getAssertion();
                    SamEnablingPolicy.AppliesToType appliesToType = vPolicy.getAppliesToType();
                    Exchange ex = message.getExchange();
                    Bus b = ex.getBus();
                    if (b.getFeatures().contains(EventFeature.class)) {
                        ai.setAsserted(true);
                        return;
                    }
                    Endpoint ep = ex.getEndpoint();
                    Bundle bundle = FrameworkUtil.getBundle(SamEnablingInterceptorProvider.class);
                    EventFeature eventFeature = null;
                    if (bundle != null) {
                        BundleContext context = FrameworkUtil.getBundle(SamEnablingInterceptorProvider.class).getBundleContext();
                        ServiceReference sref = context.getServiceReference(EventFeature.class.getName());
                        eventFeature = (EventFeature)context.getService(sref);
                    } else {
                        if (springContext == null) {
                            throw springContextException;
                        }
                        eventFeature = (EventFeature)springContext.getBean("eventFeature");
                    }
                    if (MessageUtils.isRequestor((Message)message)) {
                        Client cli;
                        if (MessageUtils.isOutbound((Message)message)) {
                            if (appliesToType != SamEnablingPolicy.AppliesToType.consumer && appliesToType != SamEnablingPolicy.AppliesToType.always || (cli = (Client)ex.get(Client.class)).getOutInterceptors().contains(WireTapOut.class)) continue;
                            eventFeature.initialize(cli, b);
                            List outInterceptors = cli.getOutInterceptors();
                            message.getInterceptorChain().add((Collection)outInterceptors);
                            outInterceptors.getClass();
                            continue;
                        }
                        if (appliesToType != SamEnablingPolicy.AppliesToType.consumer && appliesToType != SamEnablingPolicy.AppliesToType.always) continue;
                        cli = (Client)ex.get(Client.class);
                        eventFeature.initialize(cli, b);
                        continue;
                    }
                    ServerRegistry registry = (ServerRegistry)b.getExtension(ServerRegistry.class);
                    List servers = registry.getServers();
                    if (MessageUtils.isOutbound((Message)message)) {
                        if (appliesToType != SamEnablingPolicy.AppliesToType.provider && appliesToType != SamEnablingPolicy.AppliesToType.always) continue;
                        for (Server sr : servers) {
                            ei = sr.getEndpoint().getEndpointInfo();
                            if (null == ei || !ei.getAddress().equals(ep.getEndpointInfo().getAddress())) continue;
                            eventFeature.initialize(sr, b);
                        }
                        continue;
                    }
                    if (appliesToType != SamEnablingPolicy.AppliesToType.provider && appliesToType != SamEnablingPolicy.AppliesToType.always) continue;
                    for (Server sr : servers) {
                        ei = sr.getEndpoint().getEndpointInfo();
                        if (null == ei || !ei.getAddress().equals(ep.getEndpointInfo().getAddress()) || sr.getEndpoint().getInInterceptors().contains(WireTapIn.class)) continue;
                        eventFeature.initialize(sr, b);
                        List inInterceptors = sr.getEndpoint().getInInterceptors();
                        message.getInterceptorChain().add((Collection)inInterceptors);
                    }
                }
            }
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
        }
    }

    public static void shutdown() {
        if (springContext != null) {
            springContext.close();
            springContext = null;
            springContextException = new IllegalStateException("Sam enabling shut down. ");
        }
    }

    static class SAMEnableInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public SAMEnableInInterceptor() {
            super("receive");
        }

        public void handleMessage(Message message) throws Fault {
            SamEnablingInterceptorProvider.process(message);
        }
    }

    static class SAMEnableOutInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public SAMEnableOutInterceptor() {
            super("setup");
        }

        public void handleMessage(Message message) throws Fault {
            SamEnablingInterceptorProvider.process(message);
        }
    }
}

