/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.eventadmin.translator.subject;

import org.talend.esb.sam.agent.eventadmin.translator.subject.AbstractSubjectExtractorHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UsernameTokenSubjectExtractor
extends AbstractSubjectExtractorHandler {
    public static final String UT_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String UT_SUBJECT_TAG = "Username";
    public static final String SOAP_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP_HEADER_TAG = "Header";
    private final StringBuilder answer = new StringBuilder();
    private boolean inSubjectTag = false;
    private boolean inSoapHeader = true;

    @Override
    public String getSubject() {
        return this.answer.toString();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.isSoapHeaderTag(uri, localName)) {
            this.inSoapHeader = true;
        } else if (this.isUTSubjectTag(uri, localName)) {
            this.inSubjectTag = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.isSoapHeaderTag(uri, localName)) {
            if (!this.inSoapHeader) {
                throw new IllegalStateException("Missed startElement for Header");
            }
            this.inSoapHeader = false;
        } else if (this.isUTSubjectTag(uri, localName)) {
            if (!this.inSubjectTag) {
                throw new IllegalStateException("Missed startElement for Username");
            }
            this.inSubjectTag = false;
            throw new AbstractSubjectExtractorHandler.SubjectFoundException();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inSoapHeader && this.inSubjectTag) {
            this.answer.append(ch, start, length);
        }
    }

    private final boolean isUTSubjectTag(String uri, String localName) {
        return UT_SUBJECT_TAG.equals(localName) && UT_NAMESPACE.equals(uri);
    }

    private final boolean isSoapHeaderTag(String uri, String localName) {
        return SOAP_HEADER_TAG.equals(localName) && SOAP_NAMESPACE.equals(uri);
    }
}

