/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.message;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.w3c.dom.Node;

public final class CorrelationIdHelper {
    private static final Logger LOG = Logger.getLogger(CorrelationIdHelper.class.getName());
    public static final String CORRELATION_ID_KEY = "CorrelationID";
    public static final QName CORRELATION_ID_QNAME = new QName("http://www.talend.com/esb/sam/correlationId/v1", "correlationId");

    private CorrelationIdHelper() {
    }

    public static String getCorrelationId(Message message) {
        String correlationId = (String)message.get((Object)CORRELATION_ID_KEY);
        if (null == correlationId) {
            correlationId = CorrelationIdHelper.readCorrelationId(message);
        }
        if (null == correlationId) {
            correlationId = CorrelationIdHelper.readCorrelationIdSoap(message);
        }
        return correlationId;
    }

    public static void setCorrelationId(Message message, String correlationId) {
        message.put((Object)CORRELATION_ID_KEY, (Object)correlationId);
    }

    public static String readCorrelationIdSoap(Message message) {
        if (!(message instanceof SoapMessage)) {
            return null;
        }
        String correlationId = null;
        Header hdCorrelationId = ((SoapMessage)message).getHeader(CORRELATION_ID_QNAME);
        if (hdCorrelationId != null) {
            if (hdCorrelationId.getObject() instanceof String) {
                correlationId = (String)hdCorrelationId.getObject();
            } else if (hdCorrelationId.getObject() instanceof Node) {
                Node headerNode = (Node)hdCorrelationId.getObject();
                correlationId = headerNode.getTextContent();
            } else {
                LOG.warning("Found CorrelationId soap header but value is not a String or a Node! Value: " + hdCorrelationId.getObject().toString());
            }
        }
        return correlationId;
    }

    public static String readCorrelationId(Message message) {
        String correlationId = null;
        Map<String, List<String>> headers = CorrelationIdHelper.getOrCreateProtocolHeader(message);
        List<String> correlationIds = headers.get(CORRELATION_ID_KEY);
        if (correlationIds != null && correlationIds.size() > 0) {
            correlationId = correlationIds.get(0);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("HTTP header 'CorrelationID' found: " + correlationId);
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("No HTTP header 'CorrelationID' found");
        }
        return correlationId;
    }

    private static Map<String, List<String>> getOrCreateProtocolHeader(Message message) {
        HashMap headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (headers == null) {
            headers = new HashMap();
            message.put((Object)Message.PROTOCOL_HEADERS, headers);
        }
        return headers;
    }
}

