/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import fr.soleil.tango.clientapi.command.ITangoCommand;
import fr.soleil.tango.clientapi.command.MockCommand;
import fr.soleil.tango.clientapi.command.RealCommand;
import fr.soleil.tango.clientapi.util.TypeConversionUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.tango.utils.DevFailedUtils;
import org.tango.utils.TangoUtil;

public final class TangoCommand {
    private static final String TANGO_WRONG_DATA_ERROR = "TANGO_WRONG_DATA_ERROR";
    private final ITangoCommand command;

    public TangoCommand(ITangoCommand command) throws DevFailed {
        this.command = command;
    }

    public TangoCommand(String commandName, Object parameterMockValue, Object returnMockValue) throws DevFailed {
        this.command = new MockCommand(commandName, parameterMockValue, returnMockValue);
    }

    public TangoCommand(boolean isParameterVoid, String commandName, Object mockValue) throws DevFailed {
        this.command = new MockCommand(isParameterVoid, commandName, mockValue);
    }

    public TangoCommand(String commandName, boolean isMock) throws DevFailed {
        this.command = isMock ? new MockCommand(commandName) : new RealCommand(commandName);
    }

    public TangoCommand(String deviceName, String commandName) throws DevFailed {
        this.command = new RealCommand(deviceName, commandName);
    }

    public TangoCommand(String commandName) throws DevFailed {
        TangoUtil.checkFullCommandName((String)commandName);
        this.command = new RealCommand(commandName);
    }

    public String getCommandName() {
        return this.command.getCommandName();
    }

    public void execute() throws DevFailed {
        this.command.execute();
    }

    public void execute(Object value) throws DevFailed {
        this.command.execute(value);
    }

    public void execute(Object ... value) throws DevFailed {
        this.command.execute(value);
    }

    public Object executeExtract(Object value) throws DevFailed {
        return this.command.executeExtract(value);
    }

    public <T> T execute(Class<T> clazz) throws DevFailed {
        Object r = this.command.executeExtract();
        return TypeConversionUtil.castToType(clazz, r);
    }

    public Number executeExtractNumber() throws DevFailed {
        Object result = this.command.executeExtract();
        Number returnVal = null;
        if (Array.getLength(result) >= 1) {
            if (Array.get(result, 0) instanceof String || Array.get(result, 0) instanceof Boolean) {
                throw DevFailedUtils.newDevFailed((String)TANGO_WRONG_DATA_ERROR, (String)"this command must return a java.lang.Number");
            }
            returnVal = (Number)Array.get(result, 0);
        }
        return returnVal;
    }

    public <T> List<T> executeExtractList(Class<T> clazz) throws DevFailed {
        return this.extractList(this.command.executeExtract(clazz));
    }

    public Number[] executeExtractNumberArray() throws DevFailed {
        Object result = this.command.executeExtract();
        return this.extractAsNumberArray(result);
    }

    public <T> T execute(Class<T> clazz, Object value) throws DevFailed {
        Object r = this.command.executeExtract(value);
        return TypeConversionUtil.castToType(clazz, r);
    }

    public <T> T execute(Class<T> clazz, Object ... value) throws DevFailed {
        Object r = this.command.executeExtract(value);
        return TypeConversionUtil.castToType(clazz, r);
    }

    public Number executeExtractNumber(Object value) throws DevFailed {
        Object result = this.command.executeExtract(value);
        Number returnVal = null;
        if (Array.getLength(result) >= 1) {
            if (Array.get(result, 0) instanceof String || Array.get(result, 0) instanceof Boolean) {
                throw DevFailedUtils.newDevFailed((String)TANGO_WRONG_DATA_ERROR, (String)"this command must return a java.lang.Number");
            }
            returnVal = (Number)Array.get(result, 0);
        }
        return returnVal;
    }

    public <T> List<T> executeExtractList(Class<T> clazz, Object value) throws DevFailed {
        Object r = this.command.executeExtract(value);
        return this.extractList(TypeConversionUtil.castToType(clazz, r));
    }

    public <T> List<T> executeExtractList(Class<T> clazz, Object ... value) throws DevFailed {
        Object result = this.command.executeExtract(value);
        return this.extractList(TypeConversionUtil.castToArray(clazz, result));
    }

    private <T> List<T> extractList(Object result) throws DevFailed {
        ArrayList<Object> converted = new ArrayList<Object>();
        if (this.isArgoutScalar()) {
            converted.add(result);
        } else if (!this.isArgoutVoid()) {
            for (int i = 0; i < Array.getLength(result); ++i) {
                Object val = Array.get(result, i);
                converted.add(val);
            }
        }
        return converted;
    }

    private Number[] extractAsNumberArray(Object result) throws DevFailed {
        Number[] returned = null;
        if (Array.getLength(result) >= 1) {
            if (Array.get(result, 0) instanceof String || Array.get(result, 0) instanceof Boolean) {
                throw DevFailedUtils.newDevFailed((String)TANGO_WRONG_DATA_ERROR, (String)"this command must return a java.lang.Number");
            }
            returned = new Number[Array.getLength(result)];
            for (int i = 0; i < returned.length; ++i) {
                returned[i] = (Number)Array.get(result, i);
            }
        }
        return returned;
    }

    public void insertMixArgin(String[] numberArgin, String[] stringArgin) throws DevFailed {
        this.command.insertMixArgin(numberArgin, stringArgin);
    }

    public void insertMixArgin(double[] numberArgin, String[] stringArgin) throws DevFailed {
        this.command.insertMixArgin(numberArgin, stringArgin);
    }

    public void insertMixArgin(int[] numberArgin, String[] stringArgin) throws DevFailed {
        this.command.insertMixArgin(numberArgin, stringArgin);
    }

    public String extractToString(String separator) throws DevFailed {
        return this.command.extractToString(separator);
    }

    public String[] getNumMixArrayArgout() throws DevFailed {
        return this.command.getNumMixArrayArgout();
    }

    public String[] getStringMixArrayArgout() throws DevFailed {
        return this.command.getStringMixArrayArgout();
    }

    public double[] getNumDoubleMixArrayArgout() throws DevFailed {
        return this.command.getNumDoubleMixArrayArgout();
    }

    public int[] getNumLongMixArrayArgout() throws DevFailed {
        return this.command.getNumLongMixArrayArgout();
    }

    public boolean isArginScalar() throws DevFailed {
        return this.command.isArginScalar();
    }

    public boolean isArginSpectrum() throws DevFailed {
        return this.command.isArginSpectrum();
    }

    public boolean isArginVoid() throws DevFailed {
        return this.command.isArginVoid();
    }

    public boolean isArgoutVoid() throws DevFailed {
        return this.command.isArgoutVoid();
    }

    public boolean isArgoutSpectrum() throws DevFailed {
        return this.command.isArgoutSpectrum();
    }

    public boolean isArginMixFormat() throws DevFailed {
        return this.command.isArginMixFormat();
    }

    public boolean isArgoutScalar() throws DevFailed {
        return this.command.isArgoutScalar();
    }

    public boolean isArgoutMixFormat() throws DevFailed {
        return this.command.isArgoutMixFormat();
    }

    public DeviceProxy getDeviceProxy() {
        return this.command.getDeviceProxy();
    }

    public String toString() {
        ToStringBuilder str = new ToStringBuilder((Object)this);
        str.append("name", (Object)this.command.getCommandName());
        try {
            str.append("argin type", (Object)TangoConst.Tango_CmdArgTypeName[this.command.getArginType()]);
        }
        catch (DevFailed e) {
            str.append("argin type", (Object)"UNKNOWN");
        }
        try {
            str.append("argout type", (Object)TangoConst.Tango_CmdArgTypeName[this.command.getArgoutType()]);
        }
        catch (DevFailed e) {
            str.append("argout type", (Object)"UNKNOWN");
        }
        return str.toString();
    }

    public int getArginType() throws DevFailed {
        return this.command.getArginType();
    }

    public int getArgoutType() throws DevFailed {
        return this.command.getArgoutType();
    }

    public void setTimeout(int timeout) throws DevFailed {
        this.command.setTimeout(timeout);
    }
}

