/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi.command;

import fr.soleil.tango.clientapi.command.CommandExtractors;
import fr.soleil.tango.clientapi.command.CommandInserters;
import fr.soleil.tango.clientapi.command.ICommandExtractor;
import fr.soleil.tango.clientapi.command.ICommandInserter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum CommandType {
    VOID(0, new CommandInserters.VoidInserter(), new CommandExtractors.VoidExtractor()),
    BOOLEAN(1, new CommandInserters.BooleanInserter(), new CommandExtractors.BooleanExtractor()),
    SHORT(2, new CommandInserters.ShortInserter(), new CommandExtractors.ShortExtractor()),
    LONG(3, new CommandInserters.IntInserter(), new CommandExtractors.LongExtractor()),
    LONG64(23, new CommandInserters.LongInserter(), new CommandExtractors.Long64Extractor()),
    FLOAT(4, new CommandInserters.FloatInserter(), new CommandExtractors.FloatExtractor()),
    DOUBLE(5, new CommandInserters.DoubleInserter(), new CommandExtractors.DoubleExtractor()),
    USHORT(6, new CommandInserters.UShortInserter(), new CommandExtractors.UShortExtractor()),
    ULONG(7, new CommandInserters.ULongInserter(), new CommandExtractors.ULongExtractor()),
    ULONG64(24, new CommandInserters.ULong64Inserter(), new CommandExtractors.ULong64Extractor()),
    STRING(8, new CommandInserters.StringInserter(), new CommandExtractors.StringExtractor()),
    CONSTSTRING(20, new CommandInserters.StringInserter(), new CommandExtractors.StringExtractor()),
    UCHAR(22, new CommandInserters.UCharInserter(), new CommandExtractors.UCharExtractor()),
    CHAR(21, new CommandInserters.UCharInserter(), new CommandExtractors.UCharExtractor()),
    CHARARRAY(9, new CommandInserters.CharInserterArray(), new CommandExtractors.CharExtractorArray()),
    LONG64ARRAY(25, new CommandInserters.LongInserterArray(), new CommandExtractors.Long64ExtractorArray()),
    ULONG64ARRAY(26, new CommandInserters.ULong64InserterArray(), new CommandExtractors.ULong64ExtractorArray()),
    ENCODED(28, new CommandInserters.DevEncodedInserter(), new CommandExtractors.DevEncodedExtractor()),
    SHORTARRAY(10, new CommandInserters.ShortInserterArray(), new CommandExtractors.ShortExtractorArray()),
    LONGARRAY(11, new CommandInserters.IntInserterArray(), new CommandExtractors.LongExtractorArray()),
    FLOATARRAY(12, new CommandInserters.FloatInserterArray(), new CommandExtractors.FloatExtractorArray()),
    DOUBLEARRAY(13, new CommandInserters.DoubleInserterArray(), new CommandExtractors.DoubleExtractorArray()),
    USHORTARRAY(14, new CommandInserters.UShortInserterArray(), new CommandExtractors.UShortExtractorArray()),
    ULONGARRAY(15, new CommandInserters.ULongInserterArray(), new CommandExtractors.ULongExtractorArray()),
    STRINGARRAY(16, new CommandInserters.StringInserterArray(), new CommandExtractors.StringExtractorArray()),
    STATE(19, new CommandInserters.StateInserter(), new CommandExtractors.StateExtractor()),
    BOLEANARRAY(31, new CommandInserters.BooleanInserter(), new CommandExtractors.BooleanExtractor());

    private static final Map<Integer, ICommandInserter> INSERTERS_MAP;
    private static final Map<Integer, ICommandExtractor> EXTRACTORS_MAP;
    private int dataType;
    private ICommandInserter inserter;
    private ICommandExtractor extractor;

    private CommandType(int dataType, ICommandInserter inserter, ICommandExtractor extractor) {
        this.dataType = dataType;
        this.inserter = inserter;
        this.extractor = extractor;
    }

    public ICommandInserter getInserter() {
        return this.inserter;
    }

    public ICommandExtractor getExtractor() {
        return this.extractor;
    }

    public int getDataType() {
        return this.dataType;
    }

    public static ICommandInserter getInserterFromDataType(int dataType) {
        return INSERTERS_MAP.get(dataType);
    }

    public static ICommandExtractor getExtractorFromDataType(int dataType) {
        return EXTRACTORS_MAP.get(dataType);
    }

    public static int getDataTypeFromInserter(ICommandInserter inserter) {
        for (int o : INSERTERS_MAP.keySet()) {
            if (!INSERTERS_MAP.get(o).equals(inserter)) continue;
            return o;
        }
        throw new EnumConstantNotPresentException(CommandType.class, "no inserter found");
    }

    public static int getDataTypeFromExtractor(ICommandExtractor extractor) {
        for (int o : EXTRACTORS_MAP.keySet()) {
            if (!EXTRACTORS_MAP.get(o).equals(extractor)) continue;
            return o;
        }
        throw new EnumConstantNotPresentException(CommandType.class, "no inserter found");
    }

    static {
        INSERTERS_MAP = new HashMap<Integer, ICommandInserter>();
        for (CommandType s : EnumSet.allOf(CommandType.class)) {
            INSERTERS_MAP.put(s.getDataType(), s.getInserter());
        }
        EXTRACTORS_MAP = new HashMap<Integer, ICommandExtractor>();
        for (CommandType s : EnumSet.allOf(CommandType.class)) {
            EXTRACTORS_MAP.put(s.getDataType(), s.getExtractor());
        }
    }
}

