/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi.command;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.DeviceProxy;
import fr.soleil.tango.clientapi.command.ITangoCommand;
import fr.soleil.tango.clientapi.util.TypeConversionUtil;
import java.util.Arrays;
import org.tango.command.CommandTangoType;
import org.tango.utils.DevFailedUtils;

public final class MockCommand
implements ITangoCommand {
    private static final String DESC = "input type not supported";
    private static final String TANGO_WRONG_DATA_ERROR = "TANGO_WRONG_DATA_ERROR";
    private Object returnMockValue;
    private final Class<? extends Object> parameterMockType;
    private final String commandName;
    private final Class<? extends Object> returnMockType;
    private boolean returnInput;

    public MockCommand(String commandName, Object parameterMockValue, Object returnMockValue) {
        this.returnMockValue = returnMockValue;
        this.parameterMockType = parameterMockValue.getClass();
        this.returnMockType = returnMockValue.getClass();
        this.returnInput = this.parameterMockType.equals(this.returnMockType);
        this.commandName = commandName;
    }

    public MockCommand(String commandName) {
        this.parameterMockType = Void.TYPE;
        this.returnMockType = Void.TYPE;
        this.returnInput = false;
        this.commandName = commandName;
    }

    public MockCommand(boolean isParameterVoid, String commandName, Object mockValue) {
        if (isParameterVoid) {
            this.parameterMockType = Void.TYPE;
            this.returnMockType = mockValue.getClass();
            this.returnMockValue = mockValue;
            this.returnInput = true;
        } else {
            this.returnMockType = Void.TYPE;
            this.parameterMockType = mockValue.getClass();
            this.returnInput = false;
        }
        this.commandName = commandName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void execute() throws DevFailed {
    }

    @Override
    public void execute(Object value) throws DevFailed {
        if (this.returnInput) {
            this.returnMockValue = TypeConversionUtil.castToType(this.returnMockType, value);
        }
    }

    @Override
    public Object executeExtract(Object value) throws DevFailed {
        if (this.returnInput) {
            this.returnMockValue = TypeConversionUtil.castToType(this.returnMockType, value);
        }
        return this.returnMockValue;
    }

    @Override
    public Object executeExtract() throws DevFailed {
        return this.returnMockValue;
    }

    @Override
    public void insertMixArgin(String[] numberArgin, String[] stringArgin) throws DevFailed {
        if (this.returnInput) {
            if (DevVarDoubleStringArray.class.isAssignableFrom(this.parameterMockType)) {
                double[] d = TypeConversionUtil.castToType(double[].class, numberArgin);
                this.returnMockValue = new DevVarDoubleStringArray(d, stringArgin);
            } else if (DevVarLongStringArray.class.isAssignableFrom(this.parameterMockType)) {
                int[] in = TypeConversionUtil.castToType(int[].class, numberArgin);
                this.returnMockValue = new DevVarLongStringArray(in, stringArgin);
            } else {
                throw DevFailedUtils.newDevFailed((String)TANGO_WRONG_DATA_ERROR, (String)DESC);
            }
        }
    }

    @Override
    public void insertMixArgin(double[] numberArgin, String[] stringArgin) throws DevFailed {
        if (this.returnInput) {
            if (DevVarDoubleStringArray.class.isAssignableFrom(this.parameterMockType)) {
                this.returnMockValue = new DevVarDoubleStringArray(Arrays.copyOf(numberArgin, numberArgin.length), Arrays.copyOf(stringArgin, stringArgin.length));
            } else if (DevVarLongStringArray.class.isAssignableFrom(this.parameterMockType)) {
                int[] in = TypeConversionUtil.castToType(int[].class, numberArgin);
                this.returnMockValue = new DevVarLongStringArray(in, Arrays.copyOf(stringArgin, stringArgin.length));
            } else {
                throw DevFailedUtils.newDevFailed((String)TANGO_WRONG_DATA_ERROR, (String)DESC);
            }
        }
    }

    @Override
    public void insertMixArgin(int[] numberArgin, String[] stringArgin) throws DevFailed {
        if (this.returnInput) {
            if (DevVarDoubleStringArray.class.isAssignableFrom(this.parameterMockType)) {
                double[] d = TypeConversionUtil.castToType(double[].class, numberArgin);
                this.returnMockValue = new DevVarDoubleStringArray(d, Arrays.copyOf(stringArgin, stringArgin.length));
            } else if (DevVarLongStringArray.class.isAssignableFrom(this.parameterMockType)) {
                this.returnMockValue = new DevVarLongStringArray(Arrays.copyOf(numberArgin, numberArgin.length), Arrays.copyOf(stringArgin, stringArgin.length));
            } else {
                throw DevFailedUtils.newDevFailed((String)TANGO_WRONG_DATA_ERROR, (String)DESC);
            }
        }
    }

    @Override
    public String extractToString(String separator) throws DevFailed {
        String argout = "";
        if (this.isArgoutScalar()) {
            argout = this.returnMockValue.toString();
        } else if (!this.isArgoutVoid()) {
            String[] result = TypeConversionUtil.castToType(String[].class, this.returnMockValue);
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < result.length; ++i) {
                buff.append(result[i]);
                if (i == result.length - 1) continue;
                buff.append(separator);
            }
            argout = buff.toString();
        }
        return argout;
    }

    @Override
    public String[] getNumMixArrayArgout() throws DevFailed {
        String[] argout;
        if (DevVarDoubleStringArray.class.isAssignableFrom(this.returnMockType)) {
            DevVarDoubleStringArray dvdsa = (DevVarDoubleStringArray)this.returnMockValue;
            argout = TypeConversionUtil.castToType(String[].class, dvdsa.dvalue);
        } else if (DevVarLongStringArray.class.isAssignableFrom(this.returnMockType)) {
            DevVarLongStringArray dvlsa = (DevVarLongStringArray)this.returnMockValue;
            argout = TypeConversionUtil.castToType(String[].class, dvlsa.lvalue);
        } else {
            throw DevFailedUtils.newDevFailed((String)TANGO_WRONG_DATA_ERROR, (String)DESC);
        }
        return argout;
    }

    @Override
    public String[] getStringMixArrayArgout() throws DevFailed {
        String[] argout;
        if (DevVarDoubleStringArray.class.isAssignableFrom(this.returnMockType)) {
            DevVarDoubleStringArray dvdsa = (DevVarDoubleStringArray)this.returnMockValue;
            argout = Arrays.copyOf(dvdsa.svalue, dvdsa.svalue.length);
        } else if (DevVarLongStringArray.class.isAssignableFrom(this.returnMockType)) {
            DevVarLongStringArray dvlsa = (DevVarLongStringArray)this.returnMockValue;
            argout = Arrays.copyOf(dvlsa.svalue, dvlsa.svalue.length);
        } else {
            throw DevFailedUtils.newDevFailed((String)TANGO_WRONG_DATA_ERROR, (String)DESC);
        }
        return argout;
    }

    @Override
    public double[] getNumDoubleMixArrayArgout() throws DevFailed {
        double[] argout;
        if (DevVarDoubleStringArray.class.isAssignableFrom(this.returnMockType)) {
            DevVarDoubleStringArray dvdsa = (DevVarDoubleStringArray)this.returnMockValue;
            argout = Arrays.copyOf(dvdsa.dvalue, dvdsa.dvalue.length);
        } else if (DevVarLongStringArray.class.isAssignableFrom(this.returnMockType)) {
            DevVarLongStringArray dvlsa = (DevVarLongStringArray)this.returnMockValue;
            argout = TypeConversionUtil.castToType(double[].class, dvlsa.lvalue);
        } else {
            throw DevFailedUtils.newDevFailed((String)TANGO_WRONG_DATA_ERROR, (String)DESC);
        }
        return argout;
    }

    @Override
    public int[] getNumLongMixArrayArgout() throws DevFailed {
        if (!DevVarLongStringArray.class.isAssignableFrom(this.returnMockType)) {
            throw DevFailedUtils.newDevFailed((String)TANGO_WRONG_DATA_ERROR, (String)DESC);
        }
        DevVarLongStringArray dvlsa = (DevVarLongStringArray)this.returnMockValue;
        int[] argout = Arrays.copyOf(dvlsa.lvalue, dvlsa.lvalue.length);
        return argout;
    }

    @Override
    public boolean isArginScalar() throws DevFailed {
        return !this.parameterMockType.isArray();
    }

    @Override
    public boolean isArginSpectrum() throws DevFailed {
        return this.parameterMockType.isArray() && !this.isArginVoid();
    }

    @Override
    public boolean isArginVoid() throws DevFailed {
        return Void.TYPE.isAssignableFrom(this.parameterMockType);
    }

    @Override
    public boolean isArgoutVoid() throws DevFailed {
        return Void.TYPE.isAssignableFrom(this.returnMockType);
    }

    @Override
    public boolean isArgoutSpectrum() throws DevFailed {
        return this.returnMockType.isArray();
    }

    @Override
    public boolean isArginMixFormat() throws DevFailed {
        return DevVarDoubleStringArray.class.isAssignableFrom(this.parameterMockType) || DevVarLongStringArray.class.isAssignableFrom(this.parameterMockType);
    }

    @Override
    public boolean isArgoutScalar() throws DevFailed {
        return !this.returnMockType.isArray() && !this.isArgoutVoid();
    }

    @Override
    public boolean isArgoutMixFormat() throws DevFailed {
        return DevVarDoubleStringArray.class.isAssignableFrom(this.returnMockType) || DevVarLongStringArray.class.isAssignableFrom(this.returnMockType);
    }

    @Override
    public DeviceProxy getDeviceProxy() {
        return null;
    }

    @Override
    public int getArginType() throws DevFailed {
        return CommandTangoType.getTypeFromClass(this.parameterMockType).getTangoIDLType();
    }

    @Override
    public int getArgoutType() throws DevFailed {
        return CommandTangoType.getTypeFromClass(this.returnMockType).getTangoIDLType();
    }

    @Override
    public void setTimeout(int timeout) {
    }
}

