/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi.factory;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.DeviceProxyFactory;
import fr.esrf.TangoApi.Group.AttributeGroup;
import fr.esrf.TangoApi.Group.Group;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tango.utils.TangoUtil;

public final class ProxyFactory {
    private static final float LOAD = 0.75f;
    private static final int DEFAULT_TMOUT = 3000;
    private static final int MAX_ENTRIES = 100;
    private static final ProxyFactory instance = new ProxyFactory();
    private final Map<String, DeviceProxy> devicesMap = new LRUMap<String, DeviceProxy>(101, 0.75f, true);
    private final Map<String, AttributeProxy> attributesMap = new LRUMap<String, AttributeProxy>(101, 0.75f, true);
    private final Map<String, Group> groupMap;
    private final Map<String, AttributeGroup> attributeGroupMap = new LRUMap<String, AttributeGroup>(101, 0.75f, true);
    private int timeout = 3000;

    private ProxyFactory() {
        this.groupMap = new LRUMap<String, Group>(101, 0.75f, true);
    }

    public static ProxyFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceProxy createDeviceProxy(String deviceName) throws DevFailed {
        DeviceProxy dev;
        String fullDeviceName = TangoUtil.getfullNameForDevice((String)deviceName);
        Map<String, DeviceProxy> map = this.devicesMap;
        synchronized (map) {
            if (!this.devicesMap.containsKey(fullDeviceName)) {
                dev = DeviceProxyFactory.get((String)fullDeviceName);
                try {
                    dev.set_timeout_millis(this.timeout);
                }
                catch (DevFailed devFailed) {
                    // empty catch block
                }
                this.devicesMap.put(fullDeviceName, dev);
            } else {
                dev = this.devicesMap.get(fullDeviceName);
            }
        }
        return dev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeProxy createAttributeProxy(String attrName) throws DevFailed {
        AttributeProxy attr;
        String fullAttrName = TangoUtil.getfullAttributeNameForAttribute((String)attrName);
        Map<String, AttributeProxy> map = this.attributesMap;
        synchronized (map) {
            if (!this.attributesMap.containsKey(fullAttrName)) {
                attr = new AttributeProxy(fullAttrName);
                attr.set_timeout_millis(this.timeout);
                this.attributesMap.put(fullAttrName, attr);
            } else {
                attr = this.attributesMap.get(fullAttrName);
            }
        }
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group createGroup(String groupName, String ... deviceNames) throws DevFailed {
        Group grp;
        String key = Arrays.toString(deviceNames);
        Map<String, Group> map = this.groupMap;
        synchronized (map) {
            if (!this.groupMap.containsKey(key)) {
                grp = new Group(groupName);
                grp.set_timeout_millis(this.timeout, true);
                grp.add(deviceNames);
                this.groupMap.put(key, grp);
            } else {
                grp = this.groupMap.get(key);
            }
        }
        return grp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeGroup createAttributeGroup(boolean throwExceptions, String ... attributeNames) throws DevFailed {
        AttributeGroup grp;
        String key = Arrays.toString(attributeNames);
        Map<String, AttributeGroup> map = this.attributeGroupMap;
        synchronized (map) {
            if (!this.attributeGroupMap.containsKey(key)) {
                grp = new AttributeGroup(throwExceptions, attributeNames);
                grp.setTimeout(this.timeout);
                this.attributeGroupMap.put(key, grp);
            } else {
                grp = this.attributeGroupMap.get(key);
            }
        }
        return grp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimout(int timeout) throws DevFailed {
        this.timeout = timeout;
        Map<String, Object> map = this.devicesMap;
        synchronized (map) {
            for (DeviceProxy deviceProxy : this.devicesMap.values()) {
                deviceProxy.set_timeout_millis(timeout);
            }
        }
        map = this.attributesMap;
        synchronized (map) {
            for (AttributeProxy attributeProxy : this.attributesMap.values()) {
                attributeProxy.getDeviceProxy().set_timeout_millis(timeout);
                attributeProxy.set_timeout_millis(timeout);
            }
        }
        map = this.groupMap;
        synchronized (map) {
            for (Group group : this.groupMap.values()) {
                group.set_timeout_millis(timeout, true);
            }
        }
        map = this.attributeGroupMap;
        synchronized (map) {
            for (AttributeGroup attributeGroup : this.attributeGroupMap.values()) {
                attributeGroup.setTimeout(timeout);
            }
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void clearAllMap() {
        this.devicesMap.clear();
        this.attributesMap.clear();
        this.attributeGroupMap.clear();
        this.groupMap.clear();
    }

    private static class LRUMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -6898381007090501228L;

        public LRUMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder);
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 100;
        }
    }
}

