/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi.util;

import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.soleil.tango.clientapi.util.DevEncodedConverter;
import fr.soleil.tango.clientapi.util.DevStateToObjectConverter;
import fr.soleil.tango.clientapi.util.ObjectToBooleanConverter;
import fr.soleil.tango.clientapi.util.ObjectToDevStateConverter;
import fr.soleil.tango.clientapi.util.ObjectToNumberConverter;
import java.lang.reflect.Array;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.DefaultConverters;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.Transmorph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.utils.DevFailedUtils;

public final class TypeConversionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeConversionUtil.class);

    private TypeConversionUtil() {
    }

    public static Object getWritePart(Object array, AttrWriteType writeType) {
        if (writeType.equals(AttrWriteType.READ_WRITE)) {
            return Array.get(array, 1);
        }
        return Array.get(array, 0);
    }

    private static DefaultConverters creatConv() {
        DefaultConverters conv = new DefaultConverters();
        conv.addConverter((IConverter)new DevStateToObjectConverter());
        conv.addConverter((IConverter)new ObjectToDevStateConverter());
        conv.addConverter((IConverter)new ObjectToBooleanConverter());
        conv.addConverter((IConverter)new ObjectToNumberConverter());
        conv.addConverter(1, (IConverter)new DevEncodedConverter());
        return conv;
    }

    public static <T> Object castToArray(Class<T> type, Object val) throws DevFailed {
        Object result = null;
        Object array1D = val;
        if (val == null || type.isAssignableFrom(val.getClass())) {
            result = val;
        } else {
            LOGGER.debug("converting {} to {}", (Object)val.getClass().getCanonicalName(), (Object)type.getCanonicalName());
            Class<?> typeConv = Array.newInstance(type, 0).getClass();
            Transmorph transmorph = new Transmorph((IConverter)TypeConversionUtil.creatConv());
            try {
                result = transmorph.convert(array1D, typeConv);
            }
            catch (ConverterException e) {
                LOGGER.error("convertion error", (Throwable)e);
                throw DevFailedUtils.newDevFailed((Throwable)e);
            }
        }
        return result;
    }

    public static <T> T castToType(Class<T> type, Object val) throws DevFailed {
        Object result;
        if (val == null) {
            result = null;
        } else if (type.isAssignableFrom(val.getClass())) {
            result = val;
        } else {
            LOGGER.debug("converting {} to {}", (Object)val.getClass().getCanonicalName(), (Object)type.getCanonicalName());
            Object array = val;
            if (!val.getClass().isArray() && type.isArray()) {
                array = Array.newInstance(val.getClass(), 1);
                Array.set(array, 0, val);
            }
            Transmorph transmorph = new Transmorph((IConverter)TypeConversionUtil.creatConv());
            try {
                result = transmorph.convert(array, type);
            }
            catch (ConverterException e) {
                LOGGER.error("convertion error", (Throwable)e);
                throw DevFailedUtils.newDevFailed((Throwable)e);
            }
        }
        return (T)result;
    }

    public static boolean containsLetter(String s) {
        if (s == null) {
            return false;
        }
        boolean letterFound = false;
        for (int i = 0; !letterFound && i < s.length(); ++i) {
            letterFound = letterFound || Character.isLetter(s.charAt(i));
        }
        return letterFound;
    }

    public static Object extractReadOrWrite(Part part, DeviceAttribute da, Object readWrite) throws DevFailed {
        Object result;
        int dimRead = da.getDimY() != 0 ? da.getDimX() * da.getDimY() : da.getDimX();
        if (Array.getLength(readWrite) < dimRead) {
            result = readWrite;
        } else if (Part.READ.equals((Object)part)) {
            result = Array.newInstance(readWrite.getClass().getComponentType(), dimRead);
            System.arraycopy(readWrite, 0, result, 0, dimRead);
        } else {
            result = Array.newInstance(readWrite.getClass().getComponentType(), Array.getLength(readWrite) - dimRead);
            System.arraycopy(readWrite, dimRead, result, 0, Array.getLength(result));
        }
        return result;
    }

    public static enum Part {
        READ,
        WRITE;

    }
}

