/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.statecomposer;

import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.StateUtilities;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class PriorityStateManager {
    private final Map<DevState, Integer> definedPriorityMap = new HashMap<DevState, Integer>();
    private final Map<String, DevState> deviceStateMap = new LinkedHashMap<String, DevState>();

    public PriorityStateManager() {
        this.definedPriorityMap.put(DevState.ON, 0);
        this.definedPriorityMap.put(DevState.OFF, 1);
        this.definedPriorityMap.put(DevState.OPEN, 0);
        this.definedPriorityMap.put(DevState.CLOSE, 1);
        this.definedPriorityMap.put(DevState.INSERT, 0);
        this.definedPriorityMap.put(DevState.EXTRACT, 1);
        this.definedPriorityMap.put(DevState.STANDBY, 2);
        this.definedPriorityMap.put(DevState.INIT, 3);
        this.definedPriorityMap.put(DevState.MOVING, 4);
        this.definedPriorityMap.put(DevState.RUNNING, 4);
        this.definedPriorityMap.put(DevState.DISABLE, 5);
        this.definedPriorityMap.put(DevState.ALARM, 6);
        this.definedPriorityMap.put(DevState.FAULT, 7);
        this.definedPriorityMap.put(DevState.UNKNOWN, 8);
    }

    public void putStatePriority(DevState state, int priority) {
        this.definedPriorityMap.put(state, priority);
    }

    public void putDeviceState(String deviceName, DevState state) {
        this.deviceStateMap.put(deviceName, state);
    }

    public void putAllDeviceState(Map<String, DevState> aDeviceStateMap) {
        this.deviceStateMap.putAll(aDeviceStateMap);
    }

    public DevState getHighestPriorityState() {
        DevState highestPriorityState = null;
        for (Map.Entry<String, DevState> entry : this.deviceStateMap.entrySet()) {
            int currentPriority = this.definedPriorityMap.get(entry.getValue());
            if (highestPriorityState != null) {
                int highestPriority = this.definedPriorityMap.get(highestPriorityState);
                if (highestPriority >= currentPriority) continue;
                highestPriorityState = entry.getValue();
                continue;
            }
            highestPriorityState = entry.getValue();
        }
        return highestPriorityState;
    }

    public int getPriorityForState(DevState state) {
        return this.definedPriorityMap.get(state);
    }

    public Map<String, DevState> getDeviceStateMap() {
        return new HashMap<String, DevState>(this.deviceStateMap);
    }

    public String[] getDeviceStateArray() {
        String[] array = new String[this.deviceStateMap.size()];
        int i = 0;
        for (Map.Entry<String, DevState> deviceStateEntry : this.deviceStateMap.entrySet()) {
            String deviceName = deviceStateEntry.getKey();
            DevState deviceState = deviceStateEntry.getValue();
            array[i++] = deviceName + " - " + StateUtilities.getNameForState((DevState)deviceState);
        }
        return array;
    }

    public short[] getDeviceStateNumberArray() {
        short[] array = new short[this.deviceStateMap.size()];
        int i = 0;
        for (Map.Entry<String, DevState> deviceStateEntry : this.deviceStateMap.entrySet()) {
            DevState deviceState = deviceStateEntry.getValue();
            array[i++] = (short)this.getPriorityForState(deviceState);
        }
        return array;
    }
}

