/*
 * Decompiled with CFR 0.152.
 */
package org.tango.client.database.cache;

import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tango.client.database.cache.AttributeCache;
import org.tango.utils.CaseInsensitiveMap;

public final class DeviceCache {
    private final String name;
    private final Map<String, String[]> propertiesCache = new CaseInsensitiveMap();
    private final Map<String, AttributeCache> attributeCaches = new CaseInsensitiveMap();

    DeviceCache(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addProperty(String propertyName, String[] propertyValue) {
        this.propertiesCache.put(propertyName, propertyValue);
    }

    public void removeProperty(String propertyName) {
        this.propertiesCache.remove(propertyName);
    }

    public void addProperties(Map<String, String[]> properties) {
        this.propertiesCache.putAll(properties);
    }

    public Map<String, String[]> getPropertiesCache() {
        return new CaseInsensitiveMap(this.propertiesCache);
    }

    public void addAttributeCache(AttributeCache cache) {
        this.attributeCaches.put(cache.getName(), cache);
    }

    public AttributeCache getAttributeCache(String name) {
        return this.attributeCaches.get(name);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

