/*
 * Decompiled with CFR 0.152.
 */
package org.tango.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.joran.action.JMXConfiguratorAction;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.StatusPrinter;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class DefaultTangoLoggingConfiguration
extends ContextAwareBase
implements Configurator {
    public void configure(LoggerContext loggerContext) {
        this.addInfo("Setting up default configuration from ");
        ConsoleAppender ca = new ConsoleAppender();
        ca.setContext((Context)loggerContext);
        ca.setName("console");
        LayoutWrappingEncoder encoder = new LayoutWrappingEncoder();
        encoder.setContext((Context)loggerContext);
        PatternLayout layout = new PatternLayout();
        layout.setPattern("%-5level %d [%thread - %X{deviceName}] %logger{36}.%M:%L - %msg%n");
        layout.setContext((Context)loggerContext);
        layout.start();
        encoder.setLayout((Layout)layout);
        ca.setEncoder((Encoder)encoder);
        ca.start();
        JMXConfiguratorAction jmxConfiguratorAction = new JMXConfiguratorAction();
        jmxConfiguratorAction.setContext((Context)loggerContext);
        try {
            jmxConfiguratorAction.begin(null, null, (Attributes)new AttributesImpl());
        }
        catch (ActionException e) {
            this.addError("The Logback JMX configuration failed", e);
        }
        Logger jacorbLogger = loggerContext.getLogger("org.jacorb");
        jacorbLogger.setLevel(Level.ERROR);
        Logger tangoLogger = loggerContext.getLogger("org.tango.server");
        tangoLogger.setLevel(Level.INFO);
        Logger rootLogger = loggerContext.getLogger("ROOT");
        rootLogger.setLevel(Level.ERROR);
        rootLogger.addAppender((Appender)ca);
        StatusPrinter.print((Context)loggerContext);
    }
}

