/*
 * Decompiled with CFR 0.152.
 */
package org.tango.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.logging.ITangoAppender;
import org.tango.logging.LoggingLevel;
import org.tango.utils.DevFailedUtils;

public final class DeviceAppender
extends AppenderBase<ILoggingEvent>
implements ITangoAppender {
    private static final int ARGIN_SIZE = 6;
    private static Logger logger = LoggerFactory.getLogger(DeviceAppender.class);
    private final DeviceProxy loggerDevice;
    private final String loggingDeviceName;
    private Level level;
    private final String deviceName;

    public DeviceAppender(String deviceTargetName, String deviceName) throws DevFailed {
        this.loggerDevice = new DeviceProxy(deviceTargetName);
        this.loggingDeviceName = deviceTargetName;
        this.deviceName = deviceName;
        this.level = Level.DEBUG;
    }

    protected void append(ILoggingEvent eventObject) {
        if (((String)eventObject.getMDCPropertyMap().get("deviceName")).equalsIgnoreCase(this.deviceName) && eventObject.getLevel().isGreaterOrEqual(this.level)) {
            try {
                String[] dvsa = new String[6];
                int i = 0;
                dvsa[i++] = String.valueOf(eventObject.getTimeStamp());
                dvsa[i++] = eventObject.getLevel().toString();
                dvsa[i++] = eventObject.getLoggerName();
                dvsa[i++] = eventObject.getFormattedMessage();
                dvsa[i++] = "";
                dvsa[i] = eventObject.getThreadName();
                DeviceData dd = new DeviceData();
                dd.insert(dvsa);
                this.loggerDevice.command_inout_asynch("Log", dd, true);
            }
            catch (DevFailed e) {
                logger.error("failed to send log to {} : {}", (Object)this.loggerDevice.get_name(), (Object)DevFailedUtils.toString((DevFailed)e));
            }
        }
    }

    public String getLoggingDeviceName() {
        return this.loggingDeviceName;
    }

    @Override
    public void setLevel(int level) {
        this.level = LoggingLevel.getLevelFromInt(level);
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }
}

