/*
 * Decompiled with CFR 0.152.
 */
package org.tango.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.rolling.RollingFileAppender;
import org.tango.logging.ITangoAppender;
import org.tango.logging.LoggingLevel;

public final class FileAppender
extends RollingFileAppender<ILoggingEvent>
implements ITangoAppender {
    private final String deviceName;
    private Level level;

    public FileAppender(String loggingDeviceName) {
        this.deviceName = loggingDeviceName;
    }

    protected void subAppend(ILoggingEvent event) {
        if (((String)event.getMDCPropertyMap().get("deviceName")).equalsIgnoreCase(this.deviceName) && event.getLevel().isGreaterOrEqual(this.level)) {
            super.subAppend((Object)event);
        }
    }

    @Override
    public void setLevel(int level) {
        this.level = LoggingLevel.getLevelFromInt(level);
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }
}

