/*
 * Decompiled with CFR 0.152.
 */
package org.tango.orb;

import fr.esrf.Tango.DevFailed;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.CORBA.ORB;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.tango.orb.ORBManager;
import org.tango.utils.DevFailedUtils;

public final class IORDump {
    private final String iorString;
    private final String deviceName;
    private String typeId = "";
    private String iiopVersion = "";
    private String hostName = "";
    private int port = -1;

    public IORDump(String devname, String iorString) throws DevFailed {
        this.deviceName = devname;
        this.iorString = iorString;
        this.iorAnalysis();
    }

    public String toString() {
        ReflectionToStringBuilder reflectionToStringBuilder = new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        return reflectionToStringBuilder.toString();
    }

    private void iorAnalysis() throws DevFailed {
        if (!this.iorString.startsWith("IOR:")) {
            throw DevFailedUtils.newDevFailed((String)"CORBA_ERROR", (String)(this.iorString + " not an IOR"));
        }
        ORB orb = ORBManager.getOrb();
        ParsedIOR pior = new ParsedIOR((org.jacorb.orb.ORB)orb, this.iorString);
        IOR ior = pior.getIOR();
        this.typeId = ior.type_id;
        List profiles = pior.getProfiles();
        for (Profile profile : profiles) {
            if (profile instanceof IIOPProfile) {
                IIOPProfile iiopProfile = ((IIOPProfile)profile).to_GIOP_1_0();
                this.iiopVersion = iiopProfile.version().major + "." + iiopProfile.version().minor;
                String name = ((IIOPAddress)iiopProfile.getAddress()).getOriginalHost();
                InetAddress iadd = null;
                try {
                    iadd = InetAddress.getByName(name);
                }
                catch (UnknownHostException e) {
                    throw DevFailedUtils.newDevFailed((Throwable)e);
                }
                this.hostName = iadd.getHostName();
                this.port = ((IIOPAddress)iiopProfile.getAddress()).getPort();
                if (this.port >= 0) continue;
                this.port += 65536;
                continue;
            }
            throw DevFailedUtils.newDevFailed((String)"CORBA_ERROR", (String)(this.iorString + " not an IOR"));
        }
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getIIOPVersion() {
        return this.iiopVersion;
    }

    public String getDeviceName() {
        return this.deviceName;
    }
}

