/*
 * Decompiled with CFR 0.152.
 */
package org.tango.orb;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.Device;
import fr.esrf.Tango.DeviceHelper;
import fr.esrf.Tango.Device_2;
import fr.esrf.Tango.Device_2Helper;
import fr.esrf.Tango.Device_3;
import fr.esrf.Tango.Device_3Helper;
import fr.esrf.Tango.Device_4;
import fr.esrf.Tango.Device_4Helper;
import fr.esrf.Tango.Device_5;
import fr.esrf.Tango.Device_5Helper;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.client.database.DeviceImportInfo;
import org.tango.orb.InterceptorInitializer;
import org.tango.utils.DevFailedUtils;

public final class ORBManager {
    private static final String INIT_ERROR = "INIT_ERROR";
    private static final XLogger XLOGGER = XLoggerFactory.getXLogger(ORBManager.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ORBManager.class);
    public static final String NODB_POA = "nodb_poa";
    public static final String SERVER_IMPL_NAME = "nodb.device";
    public static final String OAI_ADDR = System.getProperty("OAIAddr");
    private static ORB orb;
    private static POA poa;
    private static ExecutorService orbStart;

    private ORBManager() {
    }

    public static synchronized void init(boolean useDb, String adminDeviceName) throws DevFailed {
        DeviceImportInfo importInfo;
        block10: {
            Properties props = System.getProperties();
            props.put("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
            props.put("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
            props.put("org.omg.PortableInterceptor.ORBInitializerClass.ForwardInit", InterceptorInitializer.class.getCanonicalName());
            props.put("jacorb.retries", "0");
            props.put("jacorb.retry_interval", "100");
            props.put("jacorb.codeset", (java.lang.Object)true);
            props.put("jacorb.connection.client.connect_timeout", "5000");
            String str = ORBManager.checkORBgiopMaxMsgSize();
            props.put("jacorb.maxManagedBufSize", str);
            props.put("jacorb.config.log.verbosity", "0");
            props.setProperty("jacorb.implname", SERVER_IMPL_NAME);
            orb = ORB.init((String[])new String[0], (Properties)props);
            try {
                poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            }
            catch (InvalidName e) {
                throw DevFailedUtils.newDevFailed((Throwable)e);
            }
            catch (INITIALIZE e) {
                if (useDb) break block10;
                throw DevFailedUtils.newDevFailed((Throwable)e);
            }
        }
        try {
            if (!useDb) {
                Policy[] policies = new Policy[]{poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), poa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
                POAManager manager = poa.the_POAManager();
                poa = poa.create_POA(NODB_POA, manager, policies);
            }
        }
        catch (AdapterAlreadyExists e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        catch (InvalidPolicy e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        POAManager manager = poa.the_POAManager();
        try {
            manager.activate();
        }
        catch (AdapterInactive ex) {
            throw DevFailedUtils.newDevFailed((String)"API_CantActivatePOAManager", (String)"The POA activate method throws an exception");
        }
        if (useDb && (importInfo = DatabaseFactory.getDatabase().importDevice(adminDeviceName)).isExported()) {
            LOGGER.debug("{} is set as exported in tango db - checking if it is already running", (java.lang.Object)adminDeviceName);
            ORBManager.checkServerRunning(importInfo, adminDeviceName);
        }
    }

    public static Any createAny() throws DevFailed {
        return orb.create_any();
    }

    private static void checkServerRunning(DeviceImportInfo importInfo, String toBeImported) throws DevFailed {
        XLOGGER.entry(new java.lang.Object[0]);
        Device_5 devIDL5 = null;
        Device_4 devIDL4 = null;
        Device_3 devIDL3 = null;
        Device_2 devIDL2 = null;
        Device devIDL1 = null;
        try {
            try {
                devIDL5 = ORBManager.narrowIDL5(importInfo);
            }
            catch (BAD_PARAM e) {
                try {
                    devIDL4 = ORBManager.narrowIDL4(importInfo);
                }
                catch (BAD_PARAM e4) {
                    try {
                        devIDL3 = ORBManager.narrowIDL3(importInfo);
                    }
                    catch (BAD_PARAM e1) {
                        try {
                            devIDL2 = ORBManager.narrowIDL2(importInfo);
                        }
                        catch (BAD_PARAM e2) {
                            try {
                                devIDL1 = ORBManager.narrowIDL1(importInfo);
                            }
                            catch (BAD_PARAM e3) {
                                throw DevFailedUtils.newDevFailed((Throwable)e);
                            }
                        }
                    }
                }
            }
            if (devIDL5 == null && devIDL4 == null && devIDL3 == null && devIDL2 == null && devIDL1 == null) {
                LOGGER.debug("out, device is not running");
            } else {
                ORBManager.checkDeviceName(toBeImported, devIDL5, devIDL4, devIDL3, devIDL2, devIDL1);
            }
        }
        catch (TIMEOUT e) {
            LOGGER.debug("out on TIMEOUT");
        }
        catch (BAD_OPERATION e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        catch (TRANSIENT e) {
            LOGGER.debug("out on TRANSIENT, device is not running");
        }
        catch (OBJECT_NOT_EXIST e) {
            LOGGER.debug("out on OBJECT_NOT_EXIST, device is not running");
        }
        catch (COMM_FAILURE e) {
            LOGGER.debug("out on COMM_FAILURE,, device is not running");
        }
        catch (BAD_INV_ORDER e) {
            LOGGER.debug("out on BAD_INV_ORDER,, device is not running");
        }
        XLOGGER.exit();
    }

    private static void checkDeviceName(String toBeImported, Device_5 devIDL5, Device_4 devIDL4, Device_3 devIDL3, Device_2 devIDL2, Device devIDL1) throws DevFailed {
        try {
            if (devIDL5 != null) {
                ORBManager.checkDev(toBeImported, devIDL5.name(), "5");
            } else if (devIDL4 != null) {
                ORBManager.checkDev(toBeImported, devIDL4.name(), "4");
            } else if (devIDL3 != null) {
                ORBManager.checkDev(toBeImported, devIDL3.name(), "3");
            } else if (devIDL2 != null) {
                ORBManager.checkDev(toBeImported, devIDL2.name(), "2");
            } else if (devIDL1 != null) {
                ORBManager.checkDev(toBeImported, devIDL1.name(), "1");
            }
        }
        catch (NO_RESPONSE e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        catch (COMM_FAILURE e) {
            LOGGER.debug("out on COMM_FAILURE, device is not running");
        }
        catch (OBJECT_NOT_EXIST e) {
            LOGGER.debug("out on OBJECT_NOT_EXIST, device is not running");
        }
        catch (TRANSIENT e) {
            LOGGER.debug("out on TRANSIENT, device is not running");
        }
        catch (BAD_INV_ORDER e) {
            LOGGER.debug("out on BAD_INV_ORDER, device is not running");
        }
    }

    private static void checkDev(String toBeImported, String deviceName, String version) throws DevFailed {
        if (deviceName.equals(toBeImported)) {
            throw DevFailedUtils.newDevFailed((String)INIT_ERROR, (String)("This server is already running in IDL" + version + ", exiting!"));
        }
    }

    private static Device_5 narrowIDL5(DeviceImportInfo importInfo) throws DevFailed {
        Device_5 dev = null;
        Object obj = orb.string_to_object(importInfo.getIor());
        LOGGER.debug("try narrow {} as IDL5 with PID {} because it is exported ", (java.lang.Object)importInfo.getName(), (java.lang.Object)importInfo.getPid());
        dev = Device_5Helper.narrow((Object)obj);
        LOGGER.debug("narrow IDL5 done");
        return dev;
    }

    private static Device_4 narrowIDL4(DeviceImportInfo importInfo) throws DevFailed {
        Device_4 dev = null;
        Object obj = orb.string_to_object(importInfo.getIor());
        LOGGER.debug("try narrow {} as IDL4 with PID {} because it is exported ", (java.lang.Object)importInfo.getName(), (java.lang.Object)importInfo.getPid());
        dev = Device_4Helper.narrow((Object)obj);
        LOGGER.debug("narrow IDL4 done");
        return dev;
    }

    private static Device_3 narrowIDL3(DeviceImportInfo importInfo) throws DevFailed {
        Device_3 dev = null;
        Object obj = orb.string_to_object(importInfo.getIor());
        LOGGER.debug("try narrow {} as IDL3 with PID {}", (java.lang.Object)importInfo.getName(), (java.lang.Object)importInfo.getPid());
        dev = Device_3Helper.narrow((Object)obj);
        LOGGER.debug("narrow IDL3 done");
        return dev;
    }

    private static Device_2 narrowIDL2(DeviceImportInfo importInfo) throws DevFailed {
        Device_2 dev = null;
        Object obj = orb.string_to_object(importInfo.getIor());
        LOGGER.debug("try narrow {} as IDL2 with PID {}", (java.lang.Object)importInfo.getName(), (java.lang.Object)importInfo.getPid());
        dev = Device_2Helper.narrow((Object)obj);
        LOGGER.debug("narrow IDL2 done");
        return dev;
    }

    private static Device narrowIDL1(DeviceImportInfo importInfo) throws DevFailed {
        Device dev = null;
        Object obj = orb.string_to_object(importInfo.getIor());
        LOGGER.debug("try narrow {} as IDL1 with PID {}", (java.lang.Object)importInfo.getName(), (java.lang.Object)importInfo.getPid());
        dev = DeviceHelper.narrow((Object)obj);
        LOGGER.debug("narrow IDL1 done");
        return dev;
    }

    private static void start() {
        if (orb != null) {
            orb.run();
        }
    }

    public static void startDetached() {
        orbStart = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "ORB run");
            }
        });
        orbStart.submit(new StartTask());
        LOGGER.debug("ORB started");
    }

    private static String checkORBgiopMaxMsgSize() {
        String str = "20";
        String tmp = System.getProperty("ORBgiopMaxMsgSize");
        if (tmp != null && ORBManager.checkBufferSize(tmp) != null) {
            str = tmp;
        }
        return str;
    }

    private static String checkBufferSize(String str) {
        long size;
        String result = null;
        int nbMega = 0;
        try {
            nbMega = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        long l = size = (long)nbMega * 1024L * 1024L;
        int cnt = 0;
        while (l > 0L) {
            l >>= 1;
            ++cnt;
        }
        if (Math.pow(2.0, --cnt) < (double)size) {
            ++cnt;
        }
        int jacorbSize = cnt - 4;
        result = Integer.toString(jacorbSize);
        return result;
    }

    public static ORB getOrb() throws DevFailed {
        if (orb == null) {
            throw DevFailedUtils.newDevFailed((String)"ORB not initialized");
        }
        return orb;
    }

    public static POA getPoa() throws DevFailed {
        if (poa == null) {
            throw DevFailedUtils.newDevFailed((String)"ORB not initialized");
        }
        return poa;
    }

    public static void shutdown() {
        if (orbStart != null) {
            orbStart.shutdown();
        }
        if (orb != null) {
            orb.shutdown(true);
            LOGGER.debug("ORB shutdown");
        }
    }

    private static class StartTask
    implements Callable<Void> {
        private StartTask() {
        }

        @Override
        public Void call() {
            ORBManager.start();
            return null;
        }
    }
}

