/*
 * Decompiled with CFR 0.152.
 */
package org.tango.orb;

import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.omg.CORBA.LocalObject;
import org.omg.ETF.Connection;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.ServerManager;

public final class ServerRequestInterceptor
extends LocalObject
implements org.omg.PortableInterceptor.ServerRequestInterceptor {
    private static final String GIOP_TCP = "giop:tcp:";
    private static final long serialVersionUID = 1L;
    private static final ServerRequestInterceptor INSTANCE = new ServerRequestInterceptor();
    private final Logger logger = LoggerFactory.getLogger(ServerRequestInterceptor.class);
    private final ThreadLocal<String> clientHostName = new ThreadLocal();
    private final ThreadLocal<String> giopHostAddress = new ThreadLocal();
    private final ThreadLocal<String> clientIPAddress = new ThreadLocal();
    private ThreadLocal<CompletableFuture<String>> clientHostNameFuture = new ThreadLocal();

    private ServerRequestInterceptor() {
    }

    public static ServerRequestInterceptor getInstance() {
        return INSTANCE;
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        try {
            if (ri instanceof ServerRequestInfoImpl) {
                ServerRequestInfoImpl infoImpl = (ServerRequestInfoImpl)ri;
                Connection connection = infoImpl.getConnection().getTransport();
                if (connection instanceof ServerIIOPConnection) {
                    ServerIIOPConnection connex = (ServerIIOPConnection)connection;
                    Socket sock = connex.getSocket();
                    if (sock != null) {
                        String clientIPAddressTmp = sock.getInetAddress().getHostAddress();
                        this.clientIPAddress.set(clientIPAddressTmp);
                        int remotePort = sock.getPort();
                        this.giopHostAddress.set(GIOP_TCP + clientIPAddressTmp + ":" + remotePort);
                        CompletableFuture<String> clientHostNameFutureTmp = CompletableFuture.supplyAsync(() -> {
                            String hostName;
                            try {
                                hostName = InetAddress.getByName(clientIPAddressTmp).getCanonicalHostName();
                            }
                            catch (UnknownHostException e) {
                                hostName = clientIPAddressTmp;
                            }
                            return hostName;
                        });
                        this.clientHostNameFuture.set(clientHostNameFutureTmp);
                    }
                } else {
                    this.clientIPAddress.set(ServerManager.getInstance().getHostIPAddress());
                    this.clientHostName.set(ServerManager.getInstance().getHostName());
                    this.giopHostAddress.set(GIOP_TCP + ServerManager.getInstance().getHostIPAddress());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
    }

    public void send_reply(ServerRequestInfo ri) {
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public String getClientHostName() {
        String clientHostNameS = "unresolvable host";
        if (this.clientHostNameFuture != null && this.clientHostNameFuture.get() != null) {
            try {
                clientHostNameS = this.clientHostNameFuture.get().get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {}
        } else if (this.clientHostName.get() != null) {
            clientHostNameS = this.clientHostName.get();
        }
        return clientHostNameS;
    }

    public void destroy() {
    }

    public String getClientIPAddress() {
        return this.clientIPAddress.get();
    }

    public String getGiopHostAddress() {
        return this.giopHostAddress.get();
    }
}

