/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DispLevel;
import java.lang.reflect.Array;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tango.attribute.AttributeTangoType;
import org.tango.server.IConfigurable;
import org.tango.server.PolledObjectConfig;
import org.tango.server.attribute.AttributePropertiesImpl;

public final class AttributeConfiguration
implements PolledObjectConfig,
IConfigurable {
    private String name = "";
    private AttrDataFormat format = AttrDataFormat.SCALAR;
    private AttrWriteType writable = AttrWriteType.READ;
    private Class<?> type = String.class;
    private int tangoType = 8;
    private AttributeTangoType enumType = AttributeTangoType.DEVSTRING;
    private DispLevel dispLevel = DispLevel.OPERATOR;
    private int maxX = Integer.MAX_VALUE;
    private int maxY = Integer.MAX_VALUE;
    private boolean isMemorized = false;
    private boolean isMemorizedAtInit = true;
    private int pollingPeriod = 0;
    private boolean isPolled = false;
    private AttributePropertiesImpl attributeProperties = new AttributePropertiesImpl();
    private boolean pushDataReady;
    private boolean pushChangeEvent;
    private boolean checkChangeEvent;
    private boolean pushArchiveEvent;
    private boolean checkArchivingEvent;

    public AttributeConfiguration() {
    }

    public AttributeConfiguration(AttributeConfiguration config) {
        this.name = config.name;
        this.format = config.format;
        this.writable = config.writable;
        this.type = config.type;
        this.tangoType = config.tangoType;
        this.enumType = config.enumType;
        this.dispLevel = config.dispLevel;
        this.maxX = config.maxX;
        this.maxY = config.maxY;
        this.isMemorized = config.isMemorized;
        this.isMemorizedAtInit = config.isMemorizedAtInit;
        this.pollingPeriod = config.pollingPeriod;
        this.isPolled = config.isPolled;
        this.pushDataReady = config.pushDataReady;
        this.pushChangeEvent = config.pushChangeEvent;
        this.checkChangeEvent = config.checkChangeEvent;
        this.pushArchiveEvent = config.pushArchiveEvent;
        this.checkArchivingEvent = config.checkArchivingEvent;
        this.attributeProperties = config.attributeProperties;
    }

    public DispLevel getDispLevel() {
        return this.dispLevel;
    }

    public void setDispLevel(DispLevel dispLevel) {
        this.dispLevel = dispLevel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AttrDataFormat getFormat() {
        return this.format;
    }

    public void setFormat(AttrDataFormat format) {
        this.format = format;
        if (format.equals(AttrDataFormat.SCALAR)) {
            this.maxX = 1;
            this.maxY = 0;
        } else if (format.equals(AttrDataFormat.SPECTRUM)) {
            this.maxY = 0;
        }
    }

    public AttrWriteType getWritable() {
        return this.writable;
    }

    public void setWritable(AttrWriteType writable) {
        this.writable = writable;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) throws DevFailed {
        this.type = Enum.class.isAssignableFrom(type) ? AttributeTangoType.getTypeFromClass(type).getType() : type;
        this.enumType = AttributeTangoType.getTypeFromClass(type);
        this.tangoType = this.enumType.getTangoIDLType();
        if (type.isArray()) {
            if (type.getComponentType().isArray()) {
                this.format = AttrDataFormat.IMAGE;
            } else {
                this.format = AttrDataFormat.SPECTRUM;
                this.maxY = 0;
            }
        } else {
            this.format = AttrDataFormat.SCALAR;
            this.maxX = 1;
            this.maxY = 0;
        }
    }

    public Class<?> getScalarType() {
        return this.enumType.getType();
    }

    public int getMaxX() {
        return this.maxX;
    }

    public void setMaxX(int maxX) {
        this.maxX = maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        sb.append("name", (Object)this.name);
        sb.append("format", this.format.value());
        String s = this.type.getCanonicalName() + "," + this.enumType + "=" + this.tangoType;
        sb.append("type", (Object)s);
        sb.append("writable", this.writable.value());
        sb.append("dispLevel", this.dispLevel.value());
        sb.append("isMemorized", this.isMemorized);
        sb.append("isMemorizedAtInit", this.isMemorizedAtInit);
        sb.append("isPolled", this.isPolled);
        if (this.isPolled) {
            sb.append("pollingPeriod", this.pollingPeriod);
        }
        sb.appendToString(this.attributeProperties.toString());
        return sb.toString();
    }

    public boolean isMemorized() {
        return this.isMemorized;
    }

    public void setMemorized(boolean isMemorized) {
        this.isMemorized = isMemorized;
    }

    public AttributePropertiesImpl getAttributeProperties() {
        return this.attributeProperties;
    }

    public void setAttributeProperties(AttributePropertiesImpl attributeProperties) throws DevFailed {
        this.attributeProperties = new AttributePropertiesImpl(attributeProperties);
        if (this.attributeProperties.getLabel().isEmpty() || this.attributeProperties.getLabel().equalsIgnoreCase("Not specified")) {
            this.attributeProperties.setLabel(this.name);
        }
    }

    @Override
    public void persist(String deviceName) throws DevFailed {
        this.attributeProperties.persist(deviceName, this.name);
    }

    @Override
    public void load(String deviceName) throws DevFailed {
        this.attributeProperties.load(deviceName, this.name);
    }

    @Override
    public void clear(String deviceName) throws DevFailed {
        this.attributeProperties.clear(deviceName, this.name);
    }

    public int getTangoType() {
        return this.tangoType;
    }

    public void setTangoType(int tangoType, AttrDataFormat format) throws DevFailed {
        this.setFormat(format);
        this.tangoType = tangoType;
        this.enumType = AttributeTangoType.getTypeFromTango((int)tangoType);
        this.type = format.equals(AttrDataFormat.SCALAR) ? this.enumType.getType() : (format.equals(AttrDataFormat.SPECTRUM) ? Array.newInstance(this.enumType.getType(), 0).getClass() : Array.newInstance(this.enumType.getType(), 0, 0).getClass());
    }

    public boolean isMemorizedAtInit() {
        return this.isMemorizedAtInit;
    }

    public void setMemorizedAtInit(boolean isMemorizedAtInit) {
        this.isMemorizedAtInit = isMemorizedAtInit;
    }

    public int getPollingPeriod() {
        return this.pollingPeriod;
    }

    @Override
    public void setPollingPeriod(int pollingPeriod) {
        this.pollingPeriod = pollingPeriod;
    }

    public boolean isPolled() {
        return this.isPolled;
    }

    @Override
    public void setPolled(boolean isPolled) {
        this.isPolled = isPolled;
    }

    public boolean isPushDataReady() {
        return this.pushDataReady;
    }

    public void setPushDataReady(boolean pushDataReady) {
        this.pushDataReady = pushDataReady;
    }

    public boolean isPushChangeEvent() {
        return this.pushChangeEvent;
    }

    public void setPushChangeEvent(boolean pushChangeEvent) {
        this.pushChangeEvent = pushChangeEvent;
    }

    public boolean isCheckChangeEvent() {
        return this.checkChangeEvent;
    }

    public void setCheckChangeEvent(boolean checkChangeEvent) {
        this.checkChangeEvent = checkChangeEvent;
    }

    public boolean isPushArchiveEvent() {
        return this.pushArchiveEvent;
    }

    public void setPushArchiveEvent(boolean pushArchiveEvent) {
        this.pushArchiveEvent = pushArchiveEvent;
    }

    public boolean isCheckArchivingEvent() {
        return this.checkArchivingEvent;
    }

    public void setCheckArchivingEvent(boolean checkArchivingEvent) {
        this.checkArchivingEvent = checkArchivingEvent;
    }
}

