/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttributeDim;
import fr.esrf.Tango.DevAttrHistory_4;
import fr.esrf.Tango.DevAttrHistory_5;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.EltInArray;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.DeviceDataHistory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import org.omg.CORBA.Any;
import org.tango.orb.ORBManager;
import org.tango.server.attribute.HistoryItem;
import org.tango.server.idl.CleverAnyAttribute;
import org.tango.server.idl.TangoIDLUtil;
import org.tango.utils.ArrayUtils;

public class AttributeHistoryConvertor {
    private final Deque<HistoryItem> valueHistory;
    private TimeVal[] times;
    private AttrQuality[] qualitiesArray;
    private EltInArray[] qualSizeArray;
    private AttributeDim[] readDimArray;
    private EltInArray[] readDimSizeArray;
    private AttributeDim[] writeDimArray;
    private EltInArray[] writeDimSizeArray;
    private EltInArray[] errorsArrayHist;
    private DevError[][] errorsHist;
    private Any values;
    private final String attributeName;
    private final boolean isReadWrite;
    private final int tangoType;
    private final AttrDataFormat format;

    AttributeHistoryConvertor(String attributeName, Deque<HistoryItem> valueHistory, int maxSize, int tangoType, AttrDataFormat format, boolean isReadWrite) throws DevFailed {
        this.attributeName = attributeName;
        this.valueHistory = valueHistory;
        this.isReadWrite = isReadWrite;
        this.tangoType = tangoType;
        this.format = format;
        if (!valueHistory.isEmpty()) {
            HistoryItem[] historyArray = Collections.asLifoQueue(valueHistory).toArray(new HistoryItem[valueHistory.size()]);
            HistoryItem[] returnedhistoryArray = this.createHistoryArray(maxSize, historyArray);
            this.times = new TimeVal[returnedhistoryArray.length];
            Object array = this.fillHistoryArray(returnedhistoryArray);
            this.values = CleverAnyAttribute.set(tangoType, array);
        } else {
            this.createEmptyValues();
        }
    }

    public AttributeHistoryConvertor(DeviceDataHistory[] attributeHistory, boolean isReadWrite) throws DevFailed {
        this.isReadWrite = isReadWrite;
        this.valueHistory = null;
        if (attributeHistory.length > 0) {
            this.attributeName = attributeHistory[0].name;
            this.tangoType = attributeHistory[0].dataType;
            this.format = attributeHistory[0].dataFormat;
            this.values = attributeHistory[0].extractAny();
            this.readDimArray = new AttributeDim[attributeHistory.length];
            this.readDimSizeArray = new EltInArray[attributeHistory.length];
            this.writeDimArray = new AttributeDim[attributeHistory.length];
            this.writeDimSizeArray = new EltInArray[attributeHistory.length];
            this.errorsArrayHist = new EltInArray[attributeHistory.length];
            this.errorsHist = new DevError[attributeHistory.length][];
            this.times = new TimeVal[attributeHistory.length];
            for (int i = 0; i < attributeHistory.length; ++i) {
                this.times[i] = attributeHistory[i].getTimeVal();
            }
            LinkedList<AttrQuality> qualities = new LinkedList<AttrQuality>();
            LinkedList<EltInArray> qualSize = new LinkedList<EltInArray>();
            LinkedList<AttributeDim> readDim = new LinkedList<AttributeDim>();
            LinkedList<EltInArray> readDimSize = new LinkedList<EltInArray>();
            LinkedList<AttributeDim> writeDim = new LinkedList<AttributeDim>();
            LinkedList<EltInArray> writeDimSize = new LinkedList<EltInArray>();
            LinkedList<DevError[]> errors = new LinkedList<DevError[]>();
            LinkedList<EltInArray> errorsArray = new LinkedList<EltInArray>();
            for (int i = 0; i < attributeHistory.length; ++i) {
                if (attributeHistory[i].hasFailed() && attributeHistory[i].errors.length != 0) {
                    errors.add(attributeHistory[i].errors);
                    errorsArray.add(new EltInArray(i, 1));
                }
                if (qualities.isEmpty() || !qualities.isEmpty() && attributeHistory[i].getAttrQuality() != qualities.getLast()) {
                    qualSize.add(new EltInArray(i - 1, 1));
                    qualities.add(attributeHistory[i].getAttrQuality());
                } else {
                    ++((EltInArray)qualSize.getLast()).nb_elt;
                    ++((EltInArray)qualSize.getLast()).start;
                }
                if (readDim.isEmpty() || !readDim.isEmpty() && (attributeHistory[i].getDimX() != ((AttributeDim)readDim.getLast()).dim_x || attributeHistory[i].getDimY() != ((AttributeDim)readDim.getLast()).dim_y)) {
                    readDimSize.add(new EltInArray(i - 1, 1));
                    readDim.add(new AttributeDim(attributeHistory[i].getDimX(), attributeHistory[i].getDimY()));
                } else {
                    ++((EltInArray)readDimSize.getLast()).nb_elt;
                    ++((EltInArray)readDimSize.getLast()).start;
                }
                if (!isReadWrite) continue;
                if (writeDim.isEmpty() || !writeDim.isEmpty() && (attributeHistory[i].getWrittenDimX() != ((AttributeDim)writeDim.getLast()).dim_x || attributeHistory[i].getWrittenDimY() != ((AttributeDim)writeDim.getLast()).dim_y)) {
                    writeDimSize.add(new EltInArray(i - 1, 1));
                    writeDim.add(new AttributeDim(attributeHistory[i].getWrittenDimX(), attributeHistory[i].getWrittenDimY()));
                    continue;
                }
                ++((EltInArray)writeDimSize.getLast()).nb_elt;
                ++((EltInArray)writeDimSize.getLast()).start;
            }
            this.errorsArrayHist = errorsArray.toArray(new EltInArray[0]);
            this.errorsHist = (DevError[][])errors.toArray((T[])new DevError[0][0]);
            this.readDimArray = readDim.toArray(new AttributeDim[0]);
            this.readDimSizeArray = readDimSize.toArray(new EltInArray[0]);
            this.qualitiesArray = qualities.toArray(new AttrQuality[0]);
            this.qualSizeArray = qualSize.toArray(new EltInArray[0]);
            if (isReadWrite) {
                this.writeDimArray = writeDim.toArray(new AttributeDim[0]);
                this.writeDimSizeArray = writeDimSize.toArray(new EltInArray[0]);
            } else {
                this.writeDimArray = new AttributeDim[this.readDimArray.length];
                Arrays.fill(this.writeDimArray, new AttributeDim(0, 0));
                this.writeDimSizeArray = Arrays.copyOf(this.readDimSizeArray, this.readDimSizeArray.length);
            }
        } else {
            this.attributeName = "";
            this.tangoType = 0;
            this.format = AttrDataFormat.FMT_UNKNOWN;
            this.createEmptyValues();
        }
    }

    private void createEmptyValues() throws DevFailed {
        this.qualitiesArray = new AttrQuality[0];
        this.qualSizeArray = new EltInArray[0];
        this.readDimArray = new AttributeDim[0];
        this.readDimSizeArray = new EltInArray[0];
        this.writeDimArray = new AttributeDim[0];
        this.writeDimSizeArray = new EltInArray[0];
        this.errorsArrayHist = new EltInArray[0];
        this.errorsHist = new DevError[0][];
        this.times = new TimeVal[0];
        this.values = ORBManager.createAny();
    }

    public DevAttrHistory_4 getAttrHistory4() throws DevFailed {
        return new DevAttrHistory_4(this.attributeName, this.times, this.values, this.qualitiesArray, this.qualSizeArray, this.readDimArray, this.readDimSizeArray, this.writeDimArray, this.writeDimSizeArray, this.errorsHist, this.errorsArrayHist);
    }

    public DevAttrHistory_5 getAttrHistory5() throws DevFailed {
        return new DevAttrHistory_5(this.attributeName, this.format, this.tangoType, this.times, this.values, this.qualitiesArray, this.qualSizeArray, this.readDimArray, this.readDimSizeArray, this.writeDimArray, this.writeDimSizeArray, this.errorsHist, this.errorsArrayHist);
    }

    private HistoryItem[] createHistoryArray(int maxSize, HistoryItem[] historyArray) {
        HistoryItem[] returnedhistoryArray;
        if (this.valueHistory.size() > maxSize) {
            returnedhistoryArray = new HistoryItem[maxSize];
            System.arraycopy(historyArray, historyArray.length - maxSize, returnedhistoryArray, 0, returnedhistoryArray.length);
        } else {
            returnedhistoryArray = historyArray;
        }
        return returnedhistoryArray;
    }

    private Object fillHistoryArray(HistoryItem[] returnedhistoryArray) {
        Object array = null;
        int i = 0;
        LinkedList<AttrQuality> qualities = new LinkedList<AttrQuality>();
        LinkedList<EltInArray> qualSize = new LinkedList<EltInArray>();
        LinkedList<AttributeDim> readDim = new LinkedList<AttributeDim>();
        LinkedList<EltInArray> readDimSize = new LinkedList<EltInArray>();
        LinkedList<AttributeDim> writeDim = new LinkedList<AttributeDim>();
        LinkedList<EltInArray> writeDimSize = new LinkedList<EltInArray>();
        LinkedList<DevError[]> errors = new LinkedList<DevError[]>();
        LinkedList<EltInArray> errorsArray = new LinkedList<EltInArray>();
        for (HistoryItem item : returnedhistoryArray) {
            this.times[i] = TangoIDLUtil.getTime(item.getReadValue().getTime());
            if (item.getError() != null && item.getError().length != 0) {
                errors.add(item.getError());
                errorsArray.add(new EltInArray(i, 1));
            } else {
                if (item.getWriteValue() != null && item.getWriteValue().getValue() != null && this.isReadWrite) {
                    array = ArrayUtils.addAll((Object)item.getWriteValue().getValue(), (Object)array);
                }
                if (item.getReadValue().getValue() != null) {
                    array = ArrayUtils.addAll((Object)item.getReadValue().getValue(), array);
                }
            }
            ++i;
            if (qualities.isEmpty() || !qualities.isEmpty() && item.getReadValue().getQuality() != qualities.getLast()) {
                qualSize.add(new EltInArray(i - 1, 1));
                qualities.add(item.getReadValue().getQuality());
            } else {
                ++((EltInArray)qualSize.getLast()).nb_elt;
                ++((EltInArray)qualSize.getLast()).start;
            }
            if (readDim.isEmpty() || !readDim.isEmpty() && (item.getReadValue().getXDim() != ((AttributeDim)readDim.getLast()).dim_x || item.getReadValue().getYDim() != ((AttributeDim)readDim.getLast()).dim_y)) {
                readDimSize.add(new EltInArray(i - 1, 1));
                readDim.add(new AttributeDim(item.getReadValue().getXDim(), item.getReadValue().getYDim()));
            } else {
                ++((EltInArray)readDimSize.getLast()).nb_elt;
                ++((EltInArray)readDimSize.getLast()).start;
            }
            if (!this.isReadWrite) continue;
            if (writeDim.isEmpty() || !writeDim.isEmpty() && (item.getWriteValue().getXDim() != ((AttributeDim)writeDim.getLast()).dim_x || item.getWriteValue().getYDim() != ((AttributeDim)writeDim.getLast()).dim_y)) {
                writeDimSize.add(new EltInArray(i - 1, 1));
                writeDim.add(new AttributeDim(item.getWriteValue().getXDim(), item.getWriteValue().getYDim()));
                continue;
            }
            ++((EltInArray)writeDimSize.getLast()).nb_elt;
            ++((EltInArray)writeDimSize.getLast()).start;
        }
        this.qualitiesArray = qualities.toArray(new AttrQuality[0]);
        this.qualSizeArray = qualSize.toArray(new EltInArray[0]);
        this.readDimArray = readDim.toArray(new AttributeDim[0]);
        this.readDimSizeArray = readDimSize.toArray(new EltInArray[0]);
        if (this.isReadWrite) {
            this.writeDimArray = writeDim.toArray(new AttributeDim[0]);
            this.writeDimSizeArray = writeDimSize.toArray(new EltInArray[0]);
        } else {
            this.writeDimArray = new AttributeDim[this.readDimArray.length];
            Arrays.fill(this.writeDimArray, new AttributeDim(0, 0));
            this.writeDimSizeArray = Arrays.copyOf(this.readDimSizeArray, this.readDimSizeArray.length);
        }
        this.errorsArrayHist = errorsArray.toArray(new EltInArray[0]);
        this.errorsHist = (DevError[][])errors.toArray((T[])new DevError[0][0]);
        return array;
    }
}

