/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DispLevel;
import java.lang.reflect.Array;
import java.util.concurrent.locks.ReentrantLock;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.DefaultConverters;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.Transmorph;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.attribute.AttributeTangoType;
import org.tango.server.DeviceBehaviorObject;
import org.tango.server.IPollable;
import org.tango.server.IReadableWritable;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributeHistory;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.attribute.ForwardedAttribute;
import org.tango.server.attribute.IAttributeBehavior;
import org.tango.server.attribute.ISetValueUpdater;
import org.tango.server.cache.PollingUtils;
import org.tango.server.events.EventManager;
import org.tango.server.idl.TangoIDLAttributeUtil;
import org.tango.server.properties.AttributePropertiesManager;
import org.tango.utils.ArrayUtils;
import org.tango.utils.DevFailedUtils;

public class AttributeImpl
extends DeviceBehaviorObject
implements Comparable<AttributeImpl>,
IPollable,
IReadableWritable<AttributeValue> {
    private final Logger logger = LoggerFactory.getLogger(AttributeImpl.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(AttributeImpl.class);
    private final String name;
    private final AttributeConfiguration config;
    private final AttributeHistory history;
    private final AttributePropertiesManager attributePropertiesManager;
    private final IAttributeBehavior behavior;
    private final boolean isFwdAttribute;
    private final String deviceName;
    private AttributeValue readValue;
    private AttributeValue writeValue = null;
    private DevFailed lastError;
    private boolean isAlarmToHigh;
    private boolean isOutOfLimits;
    private long writtenTimestamp = 0L;
    private boolean isDeltaAlarm;
    private volatile double executionDuration;
    private volatile double lastUpdateTime;
    private volatile double deltaTime;
    private ReentrantLock lock = new ReentrantLock();

    public AttributeImpl(IAttributeBehavior behavior, String deviceName) throws DevFailed {
        this.name = behavior.getConfiguration().getName();
        this.deviceName = deviceName;
        this.attributePropertiesManager = new AttributePropertiesManager(deviceName);
        this.isFwdAttribute = behavior instanceof ForwardedAttribute;
        this.config = behavior.getConfiguration();
        this.behavior = behavior;
        this.history = new AttributeHistory(this.config.getName(), this.config.getWritable().equals(AttrWriteType.READ_WRITE), this.config.getTangoType(), this.config.getFormat());
        this.isAlarmToHigh = false;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    public void loadTangoDbConfig() throws DevFailed {
        try {
            this.lock();
            this.applyMemorizedValue();
            this.configureAttributePropsFromDb();
        }
        finally {
            this.unlock();
        }
    }

    private Object getMemorizedValue() throws DevFailed {
        String value = this.attributePropertiesManager.getAttributePropertyFromDB(this.getName(), "__value");
        Object obj = null;
        if (value != null && !value.isEmpty() && this.config.getFormat().equals(AttrDataFormat.SCALAR)) {
            Transmorph transmorph = new Transmorph((IConverter)new DefaultConverters());
            try {
                obj = transmorph.convert((Object)value, this.config.getType());
            }
            catch (ConverterException e) {
                throw DevFailedUtils.newDevFailed((Throwable)e);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMemorizedValue() throws DevFailed {
        if (this.isMemorized() && !this.config.getWritable().equals(AttrWriteType.READ)) {
            this.xlogger.entry(new Object[]{this.config.getName()});
            Object value = this.getMemorizedValue();
            if (value != null) {
                AttributeValue attrValue = new AttributeValue(value, AttrQuality.ATTR_VALID);
                AttributeImpl attributeImpl = this;
                synchronized (attributeImpl) {
                    if (this.config.isMemorizedAtInit()) {
                        this.setValue(attrValue, true);
                    } else {
                        this.writeValue = attrValue;
                    }
                }
            }
            this.xlogger.exit();
        }
    }

    private String[] getValueAsString() throws DevFailed {
        String[] result;
        if (this.config.getFormat().equals(AttrDataFormat.SCALAR)) {
            result = new String[]{this.writeValue.getValue().toString()};
        } else {
            Object obj = this.writeValue.getValue();
            int length = Array.getLength(obj);
            result = new String[length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Array.get(obj, i).toString();
            }
        }
        return result;
    }

    @Override
    public void updateValue() throws DevFailed {
        this.xlogger.entry(new Object[]{this.getName()});
        if (!this.config.getWritable().equals(AttrWriteType.READ) && this.behavior instanceof ISetValueUpdater) {
            try {
                AttributeValue setValue = ((ISetValueUpdater)((Object)this.behavior)).getSetValue();
                if (setValue != null) {
                    this.writeValue = (AttributeValue)((ISetValueUpdater)((Object)this.behavior)).getSetValue().clone();
                    this.writeValue.setValueWithoutDim(ArrayUtils.from2DArrayToArray((Object)this.writeValue.getValue()));
                } else {
                    this.writeValue = null;
                }
            }
            catch (CloneNotSupportedException e) {
                throw DevFailedUtils.newDevFailed((Throwable)e);
            }
        }
        if (this.config.getWritable().equals(AttrWriteType.WRITE)) {
            if (this.writeValue == null) {
                this.readValue = new AttributeValue();
                this.readValue.setValue(AttributeTangoType.getDefaultValue(this.config.getType()));
            } else {
                this.readValue = this.writeValue;
            }
        } else {
            AttributeValue returnedValue = this.behavior.getValue();
            this.updateValue(returnedValue);
        }
        this.xlogger.exit((Object)this.getName());
    }

    @Override
    public void updateValue(AttributeValue inValue) throws DevFailed {
        this.xlogger.entry(new Object[]{this.getName()});
        if (inValue == null) {
            throw DevFailedUtils.newDevFailed((String)"API_AttrValueNotSet", (String)(this.name + " read value has not been updated"));
        }
        try {
            this.readValue = (AttributeValue)inValue.clone();
        }
        catch (CloneNotSupportedException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        if (this.readValue.getValue() != null && !this.readValue.getQuality().equals(AttrQuality.ATTR_INVALID)) {
            this.updateQuality(this.readValue);
        }
        try {
            if (this.readValue.getValue() == null) {
                throw DevFailedUtils.newDevFailed((String)"API_AttrValueNotSet", (String)(this.name + " read value has not been updated"));
            }
            this.checkUpdateErrors(this.readValue);
            this.readValue.setValueWithoutDim(ArrayUtils.from2DArrayToArray((Object)this.readValue.getValue()));
            TangoIDLAttributeUtil.toAttributeValue5(this, this.readValue, null);
            this.updateDefaultWritePart();
        }
        catch (DevFailed e) {
            this.readValue.setXDim(0);
            this.readValue.setYDim(0);
            this.lastError = e;
            throw e;
        }
        this.xlogger.exit((Object)this.getName());
    }

    private void checkUpdateErrors(AttributeValue returnedValue) throws DevFailed {
        if (this.config.getFormat().equals(AttrDataFormat.SCALAR) && returnedValue.getXDim() != 1 && returnedValue.getYDim() != 0) {
            throw DevFailedUtils.newDevFailed((String)"API_AttrOptProp", (String)("Data size for attribute " + this.name + " exceeds given limit"));
        }
        if (!ArrayUtils.checkDimensions((Object)returnedValue.getValue(), (int)returnedValue.getXDim(), (int)returnedValue.getYDim())) {
            throw DevFailedUtils.newDevFailed((String)"API_AttrOptProp", (String)("Data size for attribute " + this.name + " exceeds given limit"));
        }
    }

    @Override
    public String getLastDevFailed() {
        return PollingUtils.toString(this.lastError);
    }

    private void updateDefaultWritePart() throws DevFailed {
        if (this.writeValue == null && !this.config.getWritable().equals(AttrWriteType.READ)) {
            this.logger.debug("setting default value to write part");
            try {
                this.writeValue = (AttributeValue)this.readValue.clone();
            }
            catch (CloneNotSupportedException e) {
                throw DevFailedUtils.newDevFailed((Throwable)e);
            }
            this.writeValue.setValue(AttributeTangoType.getDefaultValue(this.readValue.getValue().getClass()));
        }
    }

    private void updateQuality(AttributeValue returnedValue) {
        boolean isAlarmNotConfigured;
        this.isOutOfLimits = false;
        this.isDeltaAlarm = false;
        AttributePropertiesImpl props = this.config.getAttributeProperties();
        boolean bl = isAlarmNotConfigured = props.getMaxAlarm().equals("Not specified") && props.getMinAlarm().equals("Not specified") && props.getMaxWarning().equals("Not specified") && props.getMinWarning().equals("Not specified") && props.getDeltaT().equals("Not specified");
        if (!this.config.getWritable().equals(AttrWriteType.WRITE) && this.isNumber() && !isAlarmNotConfigured) {
            double maxAlarm = props.getMaxAlarmDouble();
            double minAlarm = props.getMinAlarmDouble();
            double maxWarning = props.getMaxWarningDouble();
            double minWarning = props.getMinWarningDouble();
            long deltaT = props.getDeltaTLong();
            if (this.config.getFormat().equals(AttrDataFormat.SCALAR)) {
                this.checkScalarQuality(returnedValue, maxAlarm, minAlarm, maxWarning, minWarning, deltaT);
            } else {
                this.checkSpectrumQuality(returnedValue, maxAlarm, minAlarm, maxWarning, minWarning, deltaT);
            }
        }
    }

    private void checkSpectrumQuality(AttributeValue returnedValue, double maxAlarm, double minAlarm, double maxWarning, double minWarning, long deltaTime) {
        long currentDeltaTime = returnedValue.getTime() - this.writtenTimestamp;
        String[] readArray = ArrayUtils.toStringArray((Object)returnedValue.getValue());
        String[] writeArray = null;
        if (this.writtenTimestamp != 0L && deltaTime != 0L) {
            writeArray = ArrayUtils.toStringArray((Object)this.writeValue.getValue());
        }
        if (writeArray != null && readArray.length != writeArray.length && currentDeltaTime > deltaTime) {
            returnedValue.setQuality(AttrQuality.ATTR_ALARM);
        } else {
            int i = 0;
            for (String element : readArray) {
                double readVal = Double.parseDouble(element);
                if (writeArray != null) {
                    double deltaVal = Math.abs(this.config.getAttributeProperties().getDeltaValDouble());
                    double valWrite = Double.parseDouble(writeArray[i++]);
                    double diff = Math.abs(readVal - valWrite);
                    if (currentDeltaTime > deltaTime && diff > deltaVal) {
                        returnedValue.setQuality(AttrQuality.ATTR_ALARM);
                        this.isDeltaAlarm = true;
                        this.logger.debug("{} is delta alarm", (Object)this.getName());
                        break;
                    }
                }
                if (readVal >= maxAlarm || readVal <= minAlarm) {
                    this.isOutOfLimits = true;
                    if (readVal >= maxAlarm) {
                        this.isAlarmToHigh = true;
                        this.logger.debug("{} is too high alarm {}", (Object)this.getName(), (Object)maxAlarm);
                    } else {
                        this.isAlarmToHigh = false;
                        this.logger.debug("{} is too low alarm {}", (Object)this.getName(), (Object)minAlarm);
                    }
                    returnedValue.setQuality(AttrQuality.ATTR_ALARM);
                    break;
                }
                if (!(readVal >= maxWarning) && !(readVal <= minWarning)) continue;
                this.isOutOfLimits = true;
                if (readVal >= maxWarning) {
                    this.isAlarmToHigh = true;
                    this.logger.debug("{} is too high warning {}", (Object)this.getName(), (Object)maxWarning);
                } else {
                    this.isAlarmToHigh = false;
                    this.logger.debug("{} is too low warning {}", (Object)this.getName(), (Object)minWarning);
                }
                returnedValue.setQuality(AttrQuality.ATTR_WARNING);
                break;
            }
        }
    }

    private void checkScalarQuality(AttributeValue returnedValue, double maxAlarm, double minAlarm, double maxWarning, double minWarning, long deltaTime) {
        double valRead = Double.parseDouble(returnedValue.getValue().toString());
        this.checkScalarDeltaAlarm(returnedValue, deltaTime, valRead);
        if (!returnedValue.getQuality().equals(AttrQuality.ATTR_ALARM)) {
            if (valRead >= maxAlarm || valRead <= minAlarm) {
                this.isOutOfLimits = true;
                if (valRead >= maxAlarm) {
                    this.isAlarmToHigh = true;
                    this.logger.debug("{} is too high alarm {}", (Object)this.getName(), (Object)maxAlarm);
                } else {
                    this.isAlarmToHigh = false;
                    this.logger.debug("{} is too low alarm {}", (Object)this.getName(), (Object)minAlarm);
                }
                returnedValue.setQuality(AttrQuality.ATTR_ALARM);
            } else if (valRead >= maxWarning || valRead <= minWarning) {
                this.isOutOfLimits = true;
                if (valRead >= maxWarning) {
                    this.isAlarmToHigh = true;
                    this.logger.debug("{} is too high warning {}", (Object)this.getName(), (Object)maxWarning);
                } else {
                    this.isAlarmToHigh = false;
                    this.logger.debug("{} is too low warning {} ", (Object)this.getName(), (Object)minWarning);
                }
                returnedValue.setQuality(AttrQuality.ATTR_WARNING);
            }
        }
    }

    private void checkScalarDeltaAlarm(AttributeValue returnedValue, long deltaTime, double valRead) {
        if (this.writtenTimestamp != 0L && deltaTime != 0L) {
            double deltaVal = Math.abs(this.config.getAttributeProperties().getDeltaValDouble());
            long currentDeltaTime = returnedValue.getTime() - this.writtenTimestamp;
            double valWrite = Double.parseDouble(this.writeValue.getValue().toString());
            double diff = Math.abs(valRead - valWrite);
            if (currentDeltaTime > deltaTime && diff > deltaVal) {
                returnedValue.setQuality(AttrQuality.ATTR_ALARM);
                this.isDeltaAlarm = true;
                this.logger.debug("{} is delta alarm", (Object)this.getName());
            }
        }
    }

    public boolean isAlarmToHigh() {
        return this.isAlarmToHigh;
    }

    private void setValue(AttributeValue value, boolean fromMemorizedValue) throws DevFailed {
        if (!this.config.getWritable().equals(AttrWriteType.READ)) {
            this.checkSetErrors(value);
            try {
                this.writeValue = (AttributeValue)value.clone();
            }
            catch (CloneNotSupportedException e) {
                throw DevFailedUtils.newDevFailed((Throwable)e);
            }
            this.checkMinMaxValue();
            this.writtenTimestamp = this.writeValue.getTime();
            int dimY = this.writeValue.getYDim();
            if (this.config.getFormat().equals(AttrDataFormat.IMAGE) && dimY == 0) {
                dimY = 1;
            }
            value.setValue(ArrayUtils.fromArrayTo2DArray((Object)this.writeValue.getValue(), (int)this.writeValue.getXDim(), (int)dimY), this.writtenTimestamp);
            this.behavior.setValue(value);
            if (this.isMemorized() && this.getFormat().equals(AttrDataFormat.SCALAR) && !fromMemorizedValue) {
                this.attributePropertiesManager.setAttributePropertyInDB(this.getName(), "__value", this.getValueAsString()[0]);
            }
        } else {
            throw DevFailedUtils.newDevFailed((String)"API_AttrNotWritable", (String)(this.name + " is not writable"));
        }
    }

    @Override
    public void setValue(AttributeValue value) throws DevFailed {
        this.setValue(value, false);
    }

    private void checkMinMaxValue() throws DevFailed {
        if (this.isNumber()) {
            double val;
            double max = this.config.getAttributeProperties().getMaxValueDouble();
            double min = this.config.getAttributeProperties().getMinValueDouble();
            if (this.getFormat().equals(AttrDataFormat.SCALAR) && ((val = Double.parseDouble(this.writeValue.getValue().toString())) > max || val < min)) {
                throw DevFailedUtils.newDevFailed((String)"API_WAttrOutsideLimit", (String)("value is outside allowed range: " + min + "<" + max));
            }
        }
    }

    private void checkSetErrors(AttributeValue value) throws DevFailed {
        if (!ArrayUtils.checkDimensions((Object)value.getValue(), (int)value.getXDim(), (int)value.getYDim())) {
            throw DevFailedUtils.newDevFailed((String)"API_AttrIncorrectDataNumber", (String)(this.name + "data size does not correspond to dimensions"));
        }
        if (this.getFormat().equals(AttrDataFormat.SPECTRUM) && value.getXDim() > this.getMaxX()) {
            throw DevFailedUtils.newDevFailed((String)"API_WAttrOutsideLimit", (String)("value has a max size of " + this.getMaxX()));
        }
        if (this.getFormat().equals(AttrDataFormat.IMAGE) && (value.getXDim() > this.getMaxX() || value.getYDim() > this.getMaxY())) {
            throw DevFailedUtils.newDevFailed((String)"API_WAttrOutsideLimit", (String)(this.name + " value has a max size of " + this.getMaxX() + "*" + this.getMaxY()));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public AttrDataFormat getFormat() {
        return this.config.getFormat();
    }

    public AttrWriteType getWritable() {
        return this.config.getWritable();
    }

    public boolean isMemorized() {
        return this.config.isMemorized();
    }

    public boolean isMemorizedAtInit() {
        return this.config.isMemorizedAtInit();
    }

    public AttributePropertiesImpl getProperties() throws DevFailed {
        if (this.isFwdAttribute) {
            ForwardedAttribute fwdAttr = (ForwardedAttribute)this.behavior;
            this.config.setAttributeProperties(fwdAttr.getProperties());
        }
        return this.config.getAttributeProperties();
    }

    public void setProperties(AttributePropertiesImpl properties) throws DevFailed {
        Object memorizedValue;
        if (this.isMemorized() && (memorizedValue = this.getMemorizedValue()) != null && memorizedValue.getClass().isAssignableFrom(Number.class)) {
            double memoValue = Double.parseDouble(memorizedValue.toString());
            if (properties.getMaxValueDouble() < memoValue || properties.getMinValueDouble() > memoValue) {
                throw DevFailedUtils.newDevFailed((String)"min or max value not possible for current memorized value");
            }
        }
        this.config.setAttributeProperties(properties);
        if (this.isFwdAttribute) {
            ForwardedAttribute fwdAttr = (ForwardedAttribute)this.behavior;
            properties.setRootAttribute(fwdAttr.getRootName());
            fwdAttr.setAttributeConfiguration(this.config);
        }
        this.config.persist(this.deviceName);
        EventManager.getInstance().pushAttributeConfigEvent(this.deviceName, this.name);
    }

    public DispLevel getDispLevel() {
        return this.config.getDispLevel();
    }

    public int getMaxX() {
        return this.config.getMaxX();
    }

    public int getMaxY() {
        return this.config.getMaxY();
    }

    @Override
    public String toString() {
        ReflectionToStringBuilder reflectionToStringBuilder = new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        reflectionToStringBuilder.setExcludeFieldNames(new String[]{"readValue", "writeValue", "history", "type"});
        return reflectionToStringBuilder.toString();
    }

    @Override
    public AttributeValue getWriteValue() {
        return this.writeValue;
    }

    @Override
    public AttributeValue getReadValue() {
        return this.readValue;
    }

    public IAttributeBehavior getBehavior() {
        return this.behavior;
    }

    public void addToHistory() {
        this.history.addToHistory(this.readValue, this.writeValue, new DevError[0]);
    }

    public void fillHistory(AttributeValue[] readValues, AttributeValue[] writeValues, DevFailed[] errors) throws DevFailed {
        this.history.clear();
        if (readValues == null) {
            if (errors != null && errors.length != writeValues.length) {
                throw DevFailedUtils.newDevFailed((String)"write and errors values must have the same size");
            }
            this.logger.debug("filling attribute {} history with {} write values", (Object)this.name, (Object)writeValues.length);
            this.history.setMaxSize(writeValues.length);
            for (int i = 0; i < writeValues.length; ++i) {
                DevError[] error = new DevError[]{};
                if (errors != null && errors[i] != null) {
                    error = errors[i].errors;
                }
                this.history.addToHistory(writeValues[i], null, error);
            }
        } else if (writeValues == null) {
            if (errors != null && errors.length != readValues.length) {
                throw DevFailedUtils.newDevFailed((String)"read and errors values must have the same size");
            }
            this.logger.debug("filling attribute {} history with {} read values", (Object)this.name, (Object)readValues.length);
            this.history.setMaxSize(readValues.length);
            for (int i = 0; i < readValues.length; ++i) {
                DevError[] error = new DevError[]{};
                if (errors != null && errors[i] != null) {
                    error = errors[i].errors;
                }
                this.history.addToHistory(readValues[i], null, error);
            }
        } else {
            if (readValues.length != writeValues.length) {
                throw DevFailedUtils.newDevFailed((String)"read and write values must have the same size");
            }
            if (errors != null && errors.length != readValues.length) {
                throw DevFailedUtils.newDevFailed((String)"read and errors values must have the same size");
            }
            this.logger.debug("filling attribute {} history with {} read and write values", (Object)this.name, (Object)readValues.length);
            this.history.setMaxSize(readValues.length);
            for (int i = 0; i < readValues.length; ++i) {
                DevError[] error = new DevError[]{};
                if (errors != null && errors[i] != null) {
                    error = errors[i].errors;
                }
                this.history.addToHistory(readValues[i], writeValues[i], error);
            }
        }
    }

    public void addErrorToHistory(DevFailed e) throws DevFailed {
        this.history.addToHistory(this.readValue, this.writeValue, e.errors);
    }

    public AttributeHistory getHistory() {
        return this.history;
    }

    @Override
    public int getPollingPeriod() {
        return this.config.getPollingPeriod();
    }

    @Override
    public boolean isPolled() {
        return this.config.isPolled();
    }

    public boolean isCheckArchivingEvent() {
        return this.config.isCheckArchivingEvent();
    }

    public boolean isCheckChangeEvent() {
        return this.config.isCheckChangeEvent();
    }

    public boolean isPushArchiveEvent() {
        return this.config.isPushArchiveEvent();
    }

    public boolean isPushChangeEvent() {
        return this.config.isPushChangeEvent();
    }

    public boolean isPushDataReady() {
        return this.config.isPushDataReady();
    }

    public int getTangoType() {
        return this.config.getTangoType();
    }

    @Override
    public void configurePolling(int pollingPeriod) throws DevFailed {
        this.history.clear();
        this.config.setPolled(true);
        this.config.setPollingPeriod(Math.abs(pollingPeriod));
    }

    @Override
    public void resetPolling() throws DevFailed {
        this.config.setPolled(false);
        this.config.setPollingPeriod(0);
    }

    private void configureAttributePropsFromDb() throws DevFailed {
        this.config.load(this.deviceName);
        if (this.isFwdAttribute) {
            ((ForwardedAttribute)this.behavior).setLabel(this.config.getAttributeProperties().getLabel());
        }
    }

    public void removeProperties() throws DevFailed {
        this.config.clear(this.deviceName);
    }

    public boolean isNumber() {
        boolean result = Number.class.isAssignableFrom(this.config.getScalarType());
        result = result || Double.TYPE.isAssignableFrom(this.config.getScalarType());
        result = result || Long.TYPE.isAssignableFrom(this.config.getScalarType());
        result = result || Integer.TYPE.isAssignableFrom(this.config.getScalarType());
        result = result || Float.TYPE.isAssignableFrom(this.config.getScalarType());
        result = result || Byte.TYPE.isAssignableFrom(this.config.getScalarType());
        result = result || Short.TYPE.isAssignableFrom(this.config.getScalarType());
        return result;
    }

    public boolean isDevEncoded() {
        return DevEncoded.class.isAssignableFrom(this.config.getScalarType());
    }

    public boolean isBoolean() {
        return Boolean.TYPE.isAssignableFrom(this.config.getScalarType());
    }

    public boolean isString() {
        return String.class.isAssignableFrom(this.config.getScalarType());
    }

    public boolean isState() {
        return DevState.class.isAssignableFrom(this.config.getScalarType());
    }

    public boolean isScalar() {
        return this.config.getFormat().equals(AttrDataFormat.SCALAR);
    }

    public boolean isOutOfLimits() {
        return this.isOutOfLimits;
    }

    @Override
    public int compareTo(AttributeImpl o) {
        return this.name.compareTo(o.name);
    }

    public boolean isDeltaAlarm() {
        return this.isDeltaAlarm;
    }

    @Override
    public int getPollRingDepth() {
        return this.history.getMaxSize();
    }

    @Override
    public void setPollRingDepth(int pollRingDepth) {
        this.history.setMaxSize(pollRingDepth);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeImpl other = (AttributeImpl)obj;
        if (this.name == null && other.name != null) {
            return false;
        }
        return this.name.equals(other.name);
    }

    @Override
    public double getExecutionDuration() {
        return this.executionDuration;
    }

    @Override
    public double getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public double getDeltaTime() {
        return this.deltaTime;
    }

    @Override
    public void setPollingStats(double executionDuration, double lastUpdateTime, double deltaTime) {
        this.executionDuration = executionDuration;
        this.lastUpdateTime = lastUpdateTime;
        this.deltaTime = deltaTime;
    }

    public boolean isFwdAttribute() {
        return this.isFwdAttribute;
    }
}

