/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import java.io.Serializable;
import java.lang.reflect.Array;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tango.attribute.AttributeTangoType;
import org.tango.server.IValue;
import org.tango.utils.ArrayUtils;
import org.tango.utils.DevFailedUtils;

public final class AttributeValue
implements Cloneable,
Serializable,
IValue<Object> {
    private static final String CANNOT_BE_AN_ATTRIBUTE = " cannot be an attribute";
    private static final long serialVersionUID = 717857459565709770L;
    private Object value = null;
    private AttrQuality quality = AttrQuality.ATTR_VALID;
    private long time = 0L;
    private int xDim = 1;
    private int yDim = 1;

    public AttributeValue() {
    }

    public AttributeValue(Object value) throws DevFailed {
        this.setValue(value);
        this.quality = AttrQuality.ATTR_VALID;
        this.time = System.currentTimeMillis();
    }

    public AttributeValue(Object value, AttrQuality quality) throws DevFailed {
        this.setValue(value);
        this.quality = quality;
        this.time = System.currentTimeMillis();
    }

    public AttributeValue(Object value, AttrQuality quality, int xDim, int yDim) {
        this.value = value;
        this.quality = quality;
        this.time = System.currentTimeMillis();
        this.xDim = xDim;
        this.yDim = yDim;
    }

    public AttributeValue(Object value, AttrQuality quality, int xDim, int yDim, long time) {
        this.value = value;
        this.quality = quality;
        this.time = time;
        this.xDim = xDim;
        this.yDim = yDim;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) throws DevFailed {
        this.time = System.currentTimeMillis();
        if (value != null) {
            if (!value.getClass().isArray()) {
                if (!AttributeTangoType.ATTRIBUTE_CLASSES.contains(value.getClass())) {
                    throw DevFailedUtils.newDevFailed((String)(value.getClass().getCanonicalName() + CANNOT_BE_AN_ATTRIBUTE));
                }
                this.setXDim(1);
                this.setYDim(0);
            } else if (!value.getClass().getComponentType().isArray()) {
                if (!AttributeTangoType.ATTRIBUTE_CLASSES.contains(value.getClass().getComponentType())) {
                    throw DevFailedUtils.newDevFailed((String)(value.getClass().getCanonicalName() + CANNOT_BE_AN_ATTRIBUTE));
                }
                this.setXDim(Array.getLength(value));
                this.setYDim(0);
            } else {
                int y = Array.getLength(value);
                if (y > 0) {
                    Object xArray = Array.get(value, 0);
                    int x = Array.getLength(xArray);
                    if (x == 0) {
                        y = 0;
                    } else if (!AttributeTangoType.ATTRIBUTE_CLASSES.contains(xArray.getClass().getComponentType())) {
                        throw DevFailedUtils.newDevFailed((String)(value.getClass().getCanonicalName() + CANNOT_BE_AN_ATTRIBUTE));
                    }
                    this.setXDim(x);
                } else {
                    this.setXDim(0);
                }
                this.setYDim(y);
            }
            this.value = value;
        } else {
            this.value = null;
        }
    }

    @Override
    public void setValue(Object value, long time) throws DevFailed {
        this.setValue(value);
        this.setTime(time);
    }

    void setValueWithoutDim(Object value) throws DevFailed {
        this.value = value;
    }

    public AttrQuality getQuality() {
        return AttrQuality.from_int((int)this.quality.value());
    }

    public void setQuality(AttrQuality quality) {
        this.quality = AttrQuality.from_int((int)quality.value());
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public void setTime(long time) {
        this.time = time;
    }

    public int getXDim() {
        return this.xDim;
    }

    public void setXDim(int xDim) {
        this.xDim = xDim;
    }

    public int getYDim() {
        return this.yDim;
    }

    public void setYDim(int yDim) {
        this.yDim = yDim;
    }

    public Object clone() throws CloneNotSupportedException {
        AttributeValue newValue = (AttributeValue)super.clone();
        newValue.quality = AttrQuality.from_int((int)this.quality.value());
        newValue.value = ArrayUtils.deepCopyOf((Object)this.value);
        return newValue;
    }

    public String toString() {
        ReflectionToStringBuilder reflectionToStringBuilder = new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        return reflectionToStringBuilder.toString();
    }
}

