/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.attribute.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Queue;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public final class AttributeAppender
extends AppenderBase<ILoggingEvent> {
    private final int depth;
    private Queue<Triple<String, String, String>> log = new ArrayDeque<Triple<String, String, String>>();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yy.MM.dd '-' HH:mm:ss");

    public AttributeAppender() {
        this(1000);
    }

    public AttributeAppender(int depth) {
        this.depth = depth;
        this.log = new ArrayDeque<Triple<String, String, String>>(depth);
    }

    protected void append(ILoggingEvent eventObject) {
        while (this.log.size() >= this.depth) {
            this.log.poll();
        }
        ImmutableTriple event = new ImmutableTriple((Object)this.dateFormat.format(new Date(eventObject.getTimeStamp())), (Object)eventObject.getLevel().toString(), (Object)eventObject.getFormattedMessage());
        this.log.offer((Triple<String, String, String>)event);
    }

    public String[][] getLog() {
        String[][] result = new String[this.log.size()][3];
        int i = 0;
        for (Triple triple : this.log) {
            result[i][0] = (String)triple.getLeft();
            result[i][1] = (String)triple.getMiddle();
            result[i][2] = (String)triple.getRight();
            ++i;
        }
        return result;
    }
}

