/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.attribute.log;

import ch.qos.logback.core.Appender;
import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.StateMachineBehavior;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.attribute.IAttributeBehavior;
import org.tango.server.attribute.log.AttributeAppender;

public class LogAttribute
implements IAttributeBehavior {
    private final Logger logger = LoggerFactory.getLogger(LogAttribute.class);
    private final AttributeAppender attributeAppender;
    private String attributeName = "";

    public LogAttribute(int depth, Logger ... loggers) {
        this.logger.debug("create log attribute for loggers {}", (Object)Arrays.toString(loggers));
        this.attributeName = "log";
        this.attributeAppender = new AttributeAppender(depth);
        for (Logger logger : loggers) {
            if (!(logger instanceof ch.qos.logback.classic.Logger)) continue;
            this.logger.debug(" add appender {}", (Object)logger);
            ch.qos.logback.classic.Logger loggerBack = (ch.qos.logback.classic.Logger)logger;
            loggerBack.addAppender((Appender)this.attributeAppender);
            this.attributeAppender.start();
        }
    }

    public LogAttribute(String attributeName, int depth, Logger ... loggers) {
        this(depth, loggers);
        this.attributeName = attributeName;
    }

    @Override
    public AttributeConfiguration getConfiguration() throws DevFailed {
        AttributeConfiguration config = new AttributeConfiguration();
        config.setName(this.attributeName);
        config.setTangoType(8, AttrDataFormat.IMAGE);
        config.setWritable(AttrWriteType.READ);
        return config;
    }

    @Override
    public AttributeValue getValue() throws DevFailed {
        return new AttributeValue(this.attributeAppender.getLog());
    }

    @Override
    public void setValue(AttributeValue value) throws DevFailed {
    }

    @Override
    public StateMachineBehavior getStateMachine() throws DevFailed {
        return null;
    }
}

