/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.build.DeviceBuilder;
import org.tango.server.servant.DeviceImpl;

public class DeviceClassBuilder {
    private final Logger logger = LoggerFactory.getLogger(DeviceClassBuilder.class);
    private final Class<?> clazz;
    private final Map<String, DeviceImpl> deviceImplMap = new LinkedHashMap<String, DeviceImpl>();
    private final String className;

    public DeviceClassBuilder(Class<?> clazz, String className) {
        this.clazz = clazz;
        this.className = className;
    }

    public DeviceImpl buildDevice(String name) throws DevFailed {
        String lowerName = name.toLowerCase(Locale.ENGLISH);
        this.logger.debug("create device {} of class {}", (Object)lowerName, (Object)this.clazz.getName());
        DeviceImpl dev = new DeviceBuilder(this.clazz, this.className, name).createDevice();
        this.deviceImplMap.put(lowerName, dev);
        return dev;
    }

    public void removeDevice(String name) {
        String lowerName = name.toLowerCase(Locale.ENGLISH);
        this.logger.debug("remove device {}", (Object)lowerName);
        this.deviceImplMap.remove(lowerName);
    }

    public List<DeviceImpl> getDeviceImplList() {
        return new LinkedList<DeviceImpl>(this.deviceImplMap.values());
    }

    public DeviceImpl getDeviceImpl(String deviceName) {
        return this.deviceImplMap.get(deviceName.toLowerCase(Locale.ENGLISH));
    }

    public boolean containsDevice(String deviceName) {
        return this.deviceImplMap.containsKey(deviceName.toLowerCase(Locale.ENGLISH));
    }

    public void clearDevices() {
        this.deviceImplMap.clear();
    }

    public List<String> getDeviceNameList() {
        return new ArrayList<String>(this.deviceImplMap.keySet());
    }

    public Class<?> getDeviceClass() {
        return this.clazz;
    }

    public String getClassName() {
        return this.className;
    }
}

