/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.build.BuilderUtils;
import org.tango.server.properties.DevicePropertiesImpl;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

final class DevicePropertiesBuilder {
    private final Logger logger = LoggerFactory.getLogger(DevicePropertiesBuilder.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(DevicePropertiesBuilder.class);

    DevicePropertiesBuilder() {
    }

    public void build(Class<?> clazz, Field field, DeviceImpl device, Object businessObject) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fieldName = field.getName();
        this.logger.debug("Has a DeviceProperties : {}", (Object)fieldName);
        BuilderUtils.checkStatic(field);
        String setterName = "set" + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
        Method setter = null;
        try {
            setter = businessObject.getClass().getMethod(setterName, field.getType());
        }
        catch (NoSuchMethodException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        DevicePropertiesImpl property = new DevicePropertiesImpl(setter, businessObject, device.getName());
        device.setDeviceProperties(property);
        this.xlogger.exit();
    }
}

