/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.build.BuilderUtils;
import org.tango.server.dynamic.DynamicManager;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

final class DynamicManagerBuilder {
    private final Logger logger = LoggerFactory.getLogger(DynamicManagerBuilder.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(DynamicManagerBuilder.class);
    private static final Map<String, DynamicManager> DYN_MNGRS = new HashMap<String, DynamicManager>();

    DynamicManagerBuilder() {
    }

    public static void clear() {
        DYN_MNGRS.clear();
    }

    public void build(Field field, DeviceImpl device, Object businessObject) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String name = field.getName();
        this.logger.debug("Has a DynamicAttributeManagement : {}", (Object)name);
        BuilderUtils.checkStatic(field);
        String setterName = "set" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
        try {
            String deviceName = device.getName().toLowerCase(Locale.ENGLISH);
            Method setter = businessObject.getClass().getMethod(setterName, DynamicManager.class);
            if (DYN_MNGRS.containsKey(deviceName)) {
                setter.invoke(businessObject, DYN_MNGRS.get(deviceName));
            } else {
                DynamicManager mnger = new DynamicManager(device);
                setter.invoke(businessObject, mnger);
                DYN_MNGRS.put(deviceName, mnger);
            }
        }
        catch (IllegalArgumentException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        catch (SecurityException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        this.xlogger.exit();
    }
}

