/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.DeviceState;
import org.tango.server.annotation.State;
import org.tango.server.build.AttributeMethodBuilder;
import org.tango.server.build.BuilderUtils;
import org.tango.server.device.StateImpl;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

final class StateBuilder {
    private final Logger logger = LoggerFactory.getLogger(AttributeMethodBuilder.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(AttributeMethodBuilder.class);

    StateBuilder() {
    }

    public void build(Class<?> clazz, Field field, DeviceImpl device, Object businessObject) throws DevFailed {
        Method setter;
        Method getter;
        this.xlogger.entry(new Object[0]);
        BuilderUtils.checkStatic(field);
        String stateName = field.getName();
        String getterName = "get" + stateName.substring(0, 1).toUpperCase(Locale.ENGLISH) + stateName.substring(1);
        try {
            getter = clazz.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        if (getter.getParameterTypes().length != 0) {
            throw DevFailedUtils.newDevFailed((String)"TANGO_BUILD_FAILED", (String)(getter + " must not have a parameter"));
        }
        this.logger.debug("Has an state : {}", (Object)field.getName());
        if (getter.getReturnType() != DeviceState.class && getter.getReturnType() != DevState.class) {
            throw DevFailedUtils.newDevFailed((String)"TANGO_BUILD_FAILED", (String)(getter + " must have a return type of  " + DeviceState.class.getCanonicalName() + " or " + DevState.class.getCanonicalName()));
        }
        String setterName = "set" + stateName.substring(0, 1).toUpperCase(Locale.ENGLISH) + stateName.substring(1);
        try {
            setter = clazz.getMethod(setterName, DeviceState.class);
        }
        catch (NoSuchMethodException e) {
            try {
                setter = clazz.getMethod(setterName, DevState.class);
            }
            catch (NoSuchMethodException e1) {
                throw DevFailedUtils.newDevFailed((Throwable)e1);
            }
        }
        device.setStateImpl(new StateImpl(businessObject, getter, setter));
        State annot = field.getAnnotation(State.class);
        if (annot.isPolled()) {
            device.addAttributePolling("State", annot.pollingPeriod());
        }
        this.xlogger.exit();
    }
}

