/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.cache;

import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.cache.AttributeCacheEntryFactory;
import org.tango.server.cache.CacheRefresher;
import org.tango.server.device.AroundInvokeImpl;
import org.tango.server.device.DeviceLocker;

public final class AttributeCache {
    private final Logger logger = LoggerFactory.getLogger(AttributeCache.class);
    private ScheduledFuture<?> result;
    private final SelfPopulatingCache cache;
    private final AttributeImpl attribute;

    public AttributeCache(CacheManager manager, AttributeImpl attr, String deviceName, DeviceLocker deviceLock, AroundInvokeImpl aroundInvoke) {
        this.attribute = attr;
        String cacheName = "attrTangoPollingCache." + deviceName + "/" + attr.getName();
        Cache defaultCache = manager.getCache(cacheName);
        if (defaultCache == null) {
            manager.addCache(cacheName);
            defaultCache = manager.getCache(cacheName);
        }
        defaultCache.flush();
        this.cache = new SelfPopulatingCache((Ehcache)defaultCache, (CacheEntryFactory)new AttributeCacheEntryFactory(attr, deviceLock, deviceName, aroundInvoke));
        this.cache.getCacheConfiguration().setTimeToLiveSeconds(60L);
    }

    public void startRefresh(ScheduledExecutorService pollingPool) {
        this.logger.debug("start refresh cache of {} ", (Object)this.attribute.getName());
        CacheRefresher refresher = new CacheRefresher(this.cache, this.attribute.getName().toLowerCase(Locale.ENGLISH));
        this.result = pollingPool.scheduleAtFixedRate(refresher, 0L, this.attribute.getPollingPeriod(), TimeUnit.MILLISECONDS);
    }

    public void stopRefresh() {
        if (this.result != null) {
            this.logger.debug("stop refresh cache of {}", (Object)this.attribute.getName());
            this.result.cancel(true);
        }
    }

    public SelfPopulatingCache getCache() {
        return this.cache;
    }
}

