/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.cache;

import fr.esrf.Tango.DevFailed;
import java.util.Locale;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.InvocationContext;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.device.AroundInvokeImpl;
import org.tango.server.device.DeviceLocker;
import org.tango.server.events.EventManager;

public final class AttributeCacheEntryFactory
implements CacheEntryFactory {
    private static final double NANO_TO_MILLI = 1000000.0;
    private final Logger logger = LoggerFactory.getLogger(AttributeCacheEntryFactory.class);
    private final AttributeImpl attribute;
    private final DeviceLocker deviceLock;
    private final String deviceName;
    private final AroundInvokeImpl aroundInvoke;
    private long lastUpdateTime;

    public AttributeCacheEntryFactory(AttributeImpl attribute, DeviceLocker deviceLock, String deviceName, AroundInvokeImpl aroundInvoke) {
        this.deviceLock = deviceLock;
        this.attribute = attribute;
        this.deviceName = deviceName;
        this.aroundInvoke = aroundInvoke;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createEntry(Object key) throws DevFailed {
        AttributeValue result;
        block7: {
            this.logger.debug("Creating entry for key = {} , attribute {}/{} ", new Object[]{key, this.deviceName, this.attribute.getName()});
            result = null;
            if (!key.equals(this.attribute.getName().toLowerCase(Locale.ENGLISH))) break block7;
            Object lock = this.deviceLock.getAttributeLock();
            Object object = lock != null ? lock : new Object();
            synchronized (object) {
                this.aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_READ_ATTRIBUTE, InvocationContext.CallType.POLLING, null, this.attribute.getName()));
                this.attribute.lock();
                try {
                    long time1 = System.nanoTime();
                    this.attribute.updateValue();
                    long now = System.nanoTime();
                    long nowMilli = System.currentTimeMillis();
                    long deltaTime = now - this.lastUpdateTime;
                    this.lastUpdateTime = now;
                    long executionDuration = this.lastUpdateTime - time1;
                    this.attribute.setPollingStats((double)executionDuration / 1000000.0, nowMilli, (double)deltaTime / 1000000.0);
                    this.attribute.addToHistory();
                    result = this.attribute.getReadValue();
                    EventManager.getInstance().pushAttributeValueEvent(this.deviceName, this.attribute.getName(), true);
                    this.attribute.unlock();
                }
                catch (DevFailed e) {
                    try {
                        this.attribute.addErrorToHistory(e);
                        EventManager.getInstance().pushAttributeErrorEvent(this.deviceName, this.attribute.getName(), e, true);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        this.attribute.unlock();
                        this.aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_READ_ATTRIBUTE, InvocationContext.CallType.POLLING, null, this.attribute.getName()));
                        throw throwable;
                    }
                }
                this.aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_READ_ATTRIBUTE, InvocationContext.CallType.POLLING, null, this.attribute.getName()));
            }
        }
        return result;
    }
}

